/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import net.java.plaf.windows.common.TextComponentMenu;
import net.java.plaf.windows.common.WindowsTextFieldCaret;

public class WindowsFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private TextComponentMenu textComponentMenu;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsFormattedTextFieldUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.textComponentMenu = new TextComponentMenu(this.getComponent());
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.textComponentMenu.uninstall();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("document".equals(evt.getPropertyName()) && this.textComponentMenu != null) {
            this.textComponentMenu.documentChanged((Document)evt.getOldValue(), (Document)evt.getNewValue());
        }
        if (UIManager.getBoolean("FormattedTextField.patchCaret") && (evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled"))) {
            JTextField source = (JTextField)evt.getSource();
            if (source.isEnabled()) {
                source.setCursor(Cursor.getPredefinedCursor(2));
            } else {
                source.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    protected void paintBackground(Graphics g) {
        if (UIManager.getBoolean("FormattedTextField.patchDisabledBackground") && !this.getComponent().isEnabled()) {
            Color c = UIManager.getColor("control");
            g.setColor(c);
            g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
            return;
        }
        if (UIManager.getBoolean("FormattedTextField.patchReadOnlyBackground") && !this.getComponent().isEditable()) {
            Color c = UIManager.getColor("control");
            g.setColor(c);
            g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
            return;
        }
        super.paintBackground(g);
    }

    protected Caret createCaret() {
        if (UIManager.getBoolean("FormattedTextField.patchCaret")) {
            return new WindowsTextFieldCaret();
        }
        return super.createCaret();
    }
}

