/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static double roundToDecimal32Precision(double value) {
        return NumberUtils.round(value, MathContext.DECIMAL32.getPrecision());
    }

    public static double round(double num, int decimalDigits) {
        return NumberUtils.round(num, decimalDigits, RoundingMode.HALF_UP);
    }

    public static double round(double num, int decimalDigits, RoundingMode roundingMode) {
        if (Double.isInfinite(num) || Double.isNaN(num)) {
            return num;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(num));
        bd = bd.setScale(decimalDigits, roundingMode);
        return bd.doubleValue();
    }

    public static List<Long> splitStringToLongList(String s, char delimiter) {
        ArrayList<Long> l = new ArrayList<Long>();
        int length = s.length();
        int cur = -1;
        if (length == 0) {
            return l;
        }
        while (true) {
            int next;
            if ((next = s.indexOf(delimiter, cur + 1)) == -1) {
                l.add(NumberUtils.stringToLong(s.substring(cur + 1)));
                break;
            }
            if (next == length - 1) {
                l.add(NumberUtils.stringToLong(s.substring(cur + 1, next)));
                break;
            }
            l.add(NumberUtils.stringToLong(s.substring(cur + 1, next)));
            cur = next;
        }
        return l;
    }

    private static Long stringToLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String generateRandomNumberString(int length) {
        return RandomStringUtils.randomNumeric((int)length);
    }
}

