/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashCardInput
extends JPanel
implements FlashContent {
    private static final Logger logger = LoggerFactory.getLogger(FlashCardInput.class);
    private final JPasswordField _cardField;
    private final SubmitListener _submitListener;
    private final ActionListener _activityListener;
    private final String _header;
    private final String _trailer;
    private final Pattern _pattern;
    private final Integer _autoSubmitTimeMS;
    private final Timer _checkForCardInputTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlashCardInput.this._autoSubmitTimeMS == null) {
                return;
            }
            if (FlashCardInput.this._lastCardInput > 0L && System.currentTimeMillis() - FlashCardInput.this._lastCardInput >= (long)FlashCardInput.this._autoSubmitTimeMS.intValue()) {
                logger.debug("No card input received for " + FlashCardInput.this._autoSubmitTimeMS + "ms, assuming complete.");
                FlashCardInput.this._lastCardInput = 0L;
                FlashCardInput.this._submitListener.submitPerformed(FlashCardInput.this.extractCardNumber(true));
                FlashCardInput.this._eventHandler.hide();
            }
        }
    });
    private volatile FlashContent.FlashContentEventHandler _eventHandler;
    private volatile long _lastCardInput;

    public FlashCardInput(Builder builder) {
        String title = StringUtils.trimToNull((String)builder._title);
        String description = StringUtils.trimToEmpty((String)builder._text).replace("\n", "<br />");
        this._header = StringUtils.trimToEmpty((String)builder._header);
        this._trailer = StringUtils.trimToEmpty((String)builder._trailer);
        this._pattern = builder._pattern;
        this._autoSubmitTimeMS = builder._autoSubmitTimeMS;
        this._submitListener = builder._submitListener;
        this._activityListener = builder._activityListener;
        ActionListener submitActionListener = e -> {
            if (this._checkForCardInputTimer != null) {
                this._checkForCardInputTimer.stop();
            }
            this._submitListener.submitPerformed(this.extractCardNumber(true));
            this._eventHandler.hide();
        };
        ActionListener dismissActionListener = e -> {
            if (this._checkForCardInputTimer != null) {
                this._checkForCardInputTimer.stop();
            }
            if (this._eventHandler != null) {
                this._eventHandler.dismiss();
            }
        };
        int pad = 10;
        this.setLayout(new BorderLayout(pad, pad));
        this.setOpaque(true);
        this.setBackground(builder._background);
        this.setForeground(builder._foreground);
        this.setBorder(BorderFactory.createLineBorder(builder._foreground, 2));
        if (title != null) {
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.setBackground(builder._background);
            titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, builder._foreground), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setForeground(builder._foreground);
            titlePanel.add((Component)titleLabel, "West");
            this.add((Component)titlePanel, "North");
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(pad, pad));
        contentPanel.setBackground(builder._background);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        JLabel textLabel = new JLabel("<html><center>" + description + "</center></html>");
        textLabel.setForeground(builder._foreground);
        textLabel.setFont(new Font(textLabel.getFont().getName(), 0, textLabel.getFont().getSize()));
        contentPanel.add((Component)textLabel, "North");
        this._cardField = new JPasswordField(20);
        this._cardField.addActionListener(submitActionListener);
        this._cardField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlashCardInput.this.activityOccurred();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlashCardInput.this.activityOccurred();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlashCardInput.this.activityOccurred();
            }
        });
        contentPanel.add((Component)this._cardField, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton cancelButton = new JButton(Messages.getString(this.getClass(), "FlashCardInput.cancel", new String[0]));
        SwingUtils.setOpaqueIfRequired(cancelButton);
        cancelButton.addActionListener(dismissActionListener);
        buttonPanel.add((Component)cancelButton, "East");
        contentPanel.add((Component)buttonPanel, "South");
        this.add((Component)contentPanel, "Center");
    }

    public void addFocusListenerOnInput(FocusListener focusListener) {
        this._cardField.addFocusListener(focusListener);
    }

    private String extractCardNumber(boolean alwaysReturnCardValue) {
        String cardNo = StringUtils.trimToNull((String)new String(this._cardField.getPassword()));
        if (cardNo == null) {
            return null;
        }
        if (!alwaysReturnCardValue && this._header.length() == 0 && this._trailer.length() == 0) {
            return null;
        }
        String cardNoLower = cardNo.toLowerCase();
        if (this._header.length() > 0) {
            if (cardNoLower.startsWith(this._header)) {
                cardNo = cardNo.substring(this._header.length());
            } else {
                return alwaysReturnCardValue ? cardNo : null;
            }
        }
        if (this._trailer.length() > 0) {
            if (cardNoLower.endsWith(this._trailer)) {
                cardNo = cardNo.substring(0, cardNo.length() - this._trailer.length());
            } else {
                return alwaysReturnCardValue ? cardNo : null;
            }
        }
        if (this._pattern != null) {
            logger.debug("Trying card regex: " + this._pattern.pattern() + " on input: " + cardNo);
            Matcher m = this._pattern.matcher(cardNo);
            if (m.groupCount() < 1) {
                logger.debug("Card regex does not have a matching group: " + this._pattern.pattern());
            } else if (m.find()) {
                String cardNoBeforeRegex = cardNo;
                cardNo = StringUtils.trimToNull((String)m.group(1));
                logger.debug("Card number filter regex, got card no: " + cardNo + " from input: " + cardNoBeforeRegex);
                if (cardNo == null) {
                    cardNo = cardNoBeforeRegex;
                }
            } else {
                return alwaysReturnCardValue ? cardNo : null;
            }
        }
        return cardNo;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEventHandler(FlashContent.FlashContentEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    @Override
    public void showing() {
        this._cardField.requestFocus();
        this._checkForCardInputTimer.restart();
    }

    protected void activityOccurred() {
        if (this._eventHandler != null) {
            this._eventHandler.activityOccurred();
        }
        if (this._activityListener != null) {
            this._activityListener.actionPerformed(new ActionEvent(this, 0, "KEY_TYPED"));
        }
        this._lastCardInput = System.currentTimeMillis();
        String cardNo = this.extractCardNumber(false);
        if (cardNo != null) {
            this._submitListener.submitPerformed(cardNo);
            this._eventHandler.hide();
        }
    }

    public static interface SubmitListener {
        public void submitPerformed(String var1);
    }

    public static class Builder {
        private String _title;
        private String _text;
        private Color _background;
        private Color _foreground;
        private String _header;
        private String _trailer;
        private Pattern _pattern;
        private Integer _autoSubmitTimeMS = 3000;
        private SubmitListener _submitListener;
        private ActionListener _activityListener;

        public Builder title(String title) {
            this._title = title;
            return this;
        }

        public Builder text(String text) {
            this._text = text;
            return this;
        }

        public Builder background(Color background) {
            this._background = background;
            return this;
        }

        public Builder foreground(Color foreground) {
            this._foreground = foreground;
            return this;
        }

        public Builder header(String header) {
            this._header = header;
            return this;
        }

        public Builder trailer(String trailer) {
            this._trailer = trailer;
            return this;
        }

        public Builder pattern(Pattern pattern) {
            this._pattern = pattern;
            return this;
        }

        public Builder autoSubmitTimeMS(Integer autoSubmitTimeMS) {
            this._autoSubmitTimeMS = autoSubmitTimeMS;
            return this;
        }

        public Builder submitListener(SubmitListener submitListener) {
            this._submitListener = submitListener;
            return this;
        }

        public Builder activityListener(ActionListener activityListener) {
            this._activityListener = activityListener;
            return this;
        }

        public FlashCardInput build() {
            if (this._background == null) {
                throw new IllegalStateException("background color is required");
            }
            if (this._foreground == null) {
                throw new IllegalStateException("foreground color is required");
            }
            if (this._submitListener == null) {
                throw new IllegalStateException("submit listener is required");
            }
            return new FlashCardInput(this);
        }
    }
}

