/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.StressTester;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientDispatcher;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.client.uit.UserMacClientFrame;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.SharedSecret;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.JreCompatibleLocaleApplication;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.StringDataUtils;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.SingleInstanceLock;
import biz.papercut.pcng.util.swing.SwingUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserClient
extends JreCompatibleLocaleApplication {
    private static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private static final String PROP_CLIENT_USE_PROXY = "client.useProxy";
    private static final String ENV_CLIENT_ARGS = "PC_CLIENT_ARGS";
    private static final String DISABLE_AUTH_BY_ID_NUMBER_CMD_LINE_ARG = "N";
    private static final String DISABLE_AUTH_BY_ID_NUMBER_OPTION = "disable-auth-by-id-number";

    private UserClient() {
    }

    public static void main(String[] args) {
        String envArgs = System.getenv(ENV_CLIENT_ARGS);
        if (StringUtils.isNotBlank((String)envArgs)) {
            args = UserClient.translateCommandline(envArgs);
        }
        if (args.length > 0 && args[0].equals("--stress-test")) {
            StressTester.main(args);
            return;
        }
        try {
            UserClientConfig conf;
            SwingUtils.setupSystemLookAndFeel();
            ImageIO.setUseCache(false);
            Thread.setDefaultUncaughtExceptionHandler(UserClient::defaultExceptionHandler);
            String s = System.getProperties().getProperty(PROP_CLIENT_USE_PROXY);
            if (!StringUtils.equalsIgnoreCase((String)"true", (String)s)) {
                System.getProperties().put("http.proxySet", "false");
                System.getProperties().put("http.proxyHost", "");
                System.getProperties().put("http.proxyPort", "");
                System.getProperties().put("https.proxySet", "false");
                System.getProperties().put("https.proxyHost", "");
                System.getProperties().put("https.proxyPort", "");
                System.getProperties().put("socksProxySet", "false");
                System.getProperties().put("socksProxyHost", "");
                System.getProperties().put("socksProxyPort", "");
            }
            if ((conf = UserClient.processConfigAndArgs(args)).isUseStandardWinLAF()) {
                logger.debug("Reverting to standard L&F");
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        logger.warn("Unable to use system LAF: {}", (Object)e.getMessage());
                    }
                });
            }
            if (conf.isDoPreAuthentication()) {
                UserClient.performPreAuthentication(conf);
            }
            if (conf.isClearAuthentication()) {
                UserClient.clearAuthenticationAndExit(conf);
            }
            logger.debug("Checking instance lock");
            SingleInstanceLock lock = new SingleInstanceLock("uc-" + conf.getServerIdHash(), conf.getLockDirectory());
            if (!conf.isMultipleInstancesAllowed() && !lock.isFirstInstance()) {
                UserClient.exitWithError(UserClient.format("single-instance", new String[0]), conf.isSilent());
                return;
            }
            UserClientFrame uit = !SystemUtils.IS_OS_MAC_OSX ? new UserClientFrame() : new UserMacClientFrame();
            UserClientDispatcher userClientDispatcher = new UserClientDispatcher(conf, uit);
            userClientDispatcher.startUserClient();
            if (conf.isConnectionWatcherEnabled()) {
                userClientDispatcher.startWakeupWatcher();
            }
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            logger.error("Error starting client: {}", (Object)e.getMessage(), (Object)e);
            UserClient.exitWithError(UserClient.format("unexpected-error", e.getMessage()), false);
        }
    }

    private static void defaultExceptionHandler(Thread thread, Throwable th) {
        logger.error("Exception in thread \"{}\". {}", new Object[]{thread.getName(), th.getMessage(), th});
    }

    private static void clearAuthenticationAndExit(UserClientConfig conf) {
        ServerConnection serverConnection = null;
        try {
            logger.debug("Creating server connection to clear authentication");
            serverConnection = UserClient.createServerConnection(conf);
        }
        catch (ServerConnection.ServerConnectionException sce) {
            logger.error("Unable to connect to server to clear the authentication", (Throwable)((Object)sce));
            System.exit(1);
        }
        if (serverConnection.clearAuthentication()) {
            System.exit(0);
        } else {
            logger.error("Unable to clear authentication");
            System.exit(1);
        }
    }

    private static ServerConnection createServerConnection(UserClientConfig conf) {
        ServerConnection serverConnection = UserClientUtils.getNewServerConnection(conf, "", false);
        serverConnection.setUserName(conf.getUserName());
        serverConnection.getGlobalConfig();
        return serverConnection;
    }

    private static void performPreAuthentication(UserClientConfig conf) {
        ClientAuthResponse response;
        logger.debug("Performing Pre-Authentication");
        if (StringUtils.isBlank((String)conf.getUserName())) {
            UserClient.exitWithError("--user required for pre-authentication", false);
        }
        if (StringUtils.isBlank((String)conf.getSharedSecretFile())) {
            UserClient.exitWithError("--shared-secret-file required for pre-authentication", false);
        }
        int ttl = -1;
        if (conf.getAuthTTLDefault() != null) {
            ttl = conf.getAuthTTLDefault();
        }
        ServerConnection serverConnection = null;
        try {
            logger.debug("Creating server connection");
            serverConnection = UserClient.createServerConnection(conf);
        }
        catch (ServerConnection.ServerConnectionException sce) {
            logger.error("Unable to connect to server for pre-authenticate", (Throwable)((Object)sce));
            System.exit(1);
        }
        String sharedSecret = null;
        try {
            logger.debug("Loading shared secret from: {}", (Object)conf.getSharedSecretFile());
            File f = new File(conf.getSharedSecretFile());
            if (f.exists()) {
                SharedSecret secret = new SharedSecret(f);
                sharedSecret = secret.getSecret();
            } else {
                logger.error("Could not find shared secret: {}", (Object)f.getPath());
            }
        }
        catch (Exception e) {
            logger.error("Unable to load server's shared secret file", (Throwable)e);
        }
        if (StringUtils.isBlank(sharedSecret)) {
            logger.error("Invalid shared secret");
            System.exit(1);
        }
        if (!(response = serverConnection.authenticateUserWithSharedSecret(conf.getUserName(), sharedSecret, ttl)).isSuccess()) {
            logger.error("Pre-authentication failed: {}", (Object)response.getErrorMessage());
            System.exit(1);
        }
        logger.debug("Pre-authentication is successful for user: {}", (Object)conf.getUserName());
        System.exit(0);
    }

    private static UserClientConfig processConfigAndArgs(String[] args) {
        CommandLine cmdLine;
        UserClientConfig conf = new UserClientConfig();
        UserClient.initLogging(false);
        Properties prop = null;
        try {
            prop = ClientConfigFile.loadConfig();
        }
        catch (Exception e) {
            UserClient.exitWithError(UserClient.format("cant-load-config", e.getMessage()), conf.isSilent());
        }
        Preconditions.checkState((prop != null ? 1 : 0) != 0);
        Messages.processCustomMessages(prop);
        if (StringUtils.isNotEmpty((String)prop.getProperty("user"))) {
            conf.setUserName(prop.getProperty("user"));
            conf.setDisplayUserName(conf.getUserName());
        }
        if ("Y".equals(prop.getProperty("silent"))) {
            conf.setSilent(true);
        }
        if ("Y".equals(prop.getProperty("neverrequestidentity"))) {
            conf.setNeverRequestIdentity(true);
        }
        if ("Y".equals(prop.getProperty("standard-win-laf"))) {
            conf.setUseStandardWinLAF(true);
        }
        if ("Y".equals(prop.getProperty("disable-gui-effects"))) {
            conf.setDisableGUIEffects(true);
        }
        if ("Y".equals(prop.getProperty("minimized"))) {
            conf.setStartMinimised(true);
        }
        if ("Y".equals(prop.getProperty("noquit"))) {
            conf.setDisallowExit(true);
        }
        if ("Y".equals(prop.getProperty("disabletasktrayicon"))) {
            conf.setDisableTaskTray(true);
        }
        if ("Y".equals(prop.getProperty("disable-balloon-tips"))) {
            conf.setDisableTaskTrayBalloonTips(true);
        }
        if ("Y".equals(prop.getProperty("disable-toast-notifications"))) {
            conf.setDisableToastNotifications(true);
        }
        if ("Y".equals(prop.getProperty("hide-balance"))) {
            conf.setHideBalance(true);
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("windowposition"))) {
            conf.setWindowPosition(prop.getProperty("windowposition"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("windowtitle"))) {
            conf.setWindowTitle(prop.getProperty("windowtitle"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("background-color"))) {
            conf.setBackgroundColor(prop.getProperty("background-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("link-color"))) {
            conf.setLinkColor(prop.getProperty("link-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("link-hover-color"))) {
            conf.setLinkHoverColor(prop.getProperty("link-hover-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("additional-link-color"))) {
            conf.setAdditionalLinkColor(prop.getProperty("additional-link-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("text-color"))) {
            conf.setTextColor(prop.getProperty("text-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("negative-balance-color"))) {
            conf.setNegativeBalanceColor(prop.getProperty("negative-balance-color"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("lockdir"))) {
            conf.setLockDirectory(prop.getProperty("lockdir"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("accounts-file"))) {
            conf.setClientAccountsFile(prop.getProperty("accounts-file"));
        }
        conf.setLoadDisabledAccounts("Y".equals(prop.getProperty("load-disabled-accounts", "Y")));
        conf.setClientAccountsFileDisablePreload("Y".equals(prop.getProperty("accounts-file-disable-preload")));
        if (StringUtils.isNotBlank((String)prop.getProperty("default-selection"))) {
            conf.setDefaultSelectedOption(ChargeToAccountType.fromClientConfigValue((String)prop.getProperty("default-selection")));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("default-account"))) {
            conf.setDefaultSelectedAccount(prop.getProperty("default-account"));
        }
        if (prop.getProperty("default-account-pin") != null) {
            conf.setDefaultSelectedAccountPin(prop.getProperty("default-account-pin"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("auth-ttl-values"))) {
            conf.setAuthTTLValues(prop.getProperty("auth-ttl-values"));
        }
        if (StringUtils.isNotBlank((String)prop.getProperty("auth-ttl-default"))) {
            try {
                conf.setAuthTTLDefault(Integer.valueOf(prop.getProperty("auth-ttl-default")));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ("Y".equals(prop.getProperty(DISABLE_AUTH_BY_ID_NUMBER_OPTION))) {
            conf.setDisableAuthByIdNumber(true);
        }
        if ("Y".equals(prop.getProperty("disable-account-cache"))) {
            conf.setDisableAccountCache(true);
        }
        if ((cmdLine = UserClient.parseCommandLine(args)).hasOption("s")) {
            conf.setSilent(true);
        }
        if (cmdLine.hasOption("b")) {
            conf.setDebugEnabled(true);
        }
        if (cmdLine.hasOption("B")) {
            conf.setHideBalance(true);
        }
        if (cmdLine.hasOption("a")) {
            conf.setAlwaysRequestIdentity(true);
        }
        if (cmdLine.hasOption("A")) {
            conf.setClientAccountsFile(cmdLine.getOptionValue("A"));
        }
        if (cmdLine.hasOption("AP")) {
            conf.setClientAccountsFileDisablePreload(true);
        }
        if (cmdLine.hasOption("n")) {
            conf.setNeverRequestIdentity(true);
        }
        if (cmdLine.hasOption("m")) {
            conf.setStartMinimised(true);
        }
        if (cmdLine.hasOption("l")) {
            conf.setMultipleInstancesAllowed(true);
        }
        if (cmdLine.hasOption("d")) {
            conf.setLockDirectory(cmdLine.getOptionValue("d"));
        }
        if (cmdLine.hasOption("w")) {
            conf.setUseStandardWinLAF(true);
        }
        if (cmdLine.hasOption("p")) {
            conf.setWindowPosition(cmdLine.getOptionValue("p"));
        }
        if (cmdLine.hasOption("t")) {
            conf.setWindowTitle(cmdLine.getOptionValue("t"));
        }
        if (cmdLine.hasOption("k")) {
            conf.setBackgroundColor(cmdLine.getOptionValue("k"));
        }
        if (cmdLine.hasOption("i")) {
            conf.setLinkColor(cmdLine.getOptionValue("i"));
        }
        if (cmdLine.hasOption("c")) {
            conf.setLinkHoverColor(cmdLine.getOptionValue("c"));
        }
        if (cmdLine.hasOption("x")) {
            conf.setTextColor(cmdLine.getOptionValue("x"));
        }
        if (cmdLine.hasOption("X")) {
            conf.setNegativeBalanceColor(cmdLine.getOptionValue("X"));
        }
        if (cmdLine.hasOption("q")) {
            conf.setDisallowExit(true);
        }
        if (cmdLine.hasOption("I")) {
            conf.setDisableTaskTray(true);
        }
        if (cmdLine.hasOption("O")) {
            conf.setDisableToastNotifications(true);
        }
        if (cmdLine.hasOption("o")) {
            conf.setDisableTaskTrayBalloonTips(true);
        }
        if (cmdLine.hasOption("u")) {
            conf.setUserName(cmdLine.getOptionValue("u"));
            conf.setDisplayUserName(conf.getUserName());
        }
        if (cmdLine.hasOption("f")) {
            conf.setDefaultSelectedOption(ChargeToAccountType.fromClientConfigValue((String)cmdLine.getOptionValue("f")));
        }
        if (cmdLine.hasOption("F")) {
            conf.setDefaultSelectedAccount(cmdLine.getOptionValue("F"));
        }
        if (cmdLine.hasOption("P")) {
            conf.setDefaultSelectedAccountPin(cmdLine.getOptionValue("P"));
        }
        if (cmdLine.hasOption("T")) {
            conf.setAuthTTLValues(cmdLine.getOptionValue("T"));
        }
        if (cmdLine.hasOption("D")) {
            try {
                conf.setAuthTTLDefault(Integer.valueOf(cmdLine.getOptionValue("D")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (cmdLine.hasOption("K")) {
            conf.setDoPreAuthentication(true);
        }
        if (cmdLine.hasOption("U")) {
            conf.setUsePreAuthentication(true);
        }
        if (cmdLine.hasOption("S")) {
            conf.setSharedSecretFile(cmdLine.getOptionValue("S"));
        }
        if (cmdLine.hasOption("C")) {
            conf.setClearAuthentication(true);
        }
        if (cmdLine.hasOption(DISABLE_AUTH_BY_ID_NUMBER_CMD_LINE_ARG)) {
            conf.setDisableAuthByIdNumber(true);
        }
        conf.setServerName(prop.getProperty("server-name"));
        conf.setServerIP(prop.getProperty("server-ip"));
        try {
            int serverPort = Integer.parseInt(prop.getProperty("server-port"));
            conf.setServerPort(serverPort);
        }
        catch (NumberFormatException e) {
            conf.setServerPort(-1);
        }
        try {
            int timeoutSecs = Integer.parseInt(prop.getProperty("connection-timeout-secs"));
            if (timeoutSecs > 0) {
                conf.setTimeoutSecs(timeoutSecs);
            }
        }
        catch (Exception timeoutSecs) {
            // empty catch block
        }
        boolean hasValidServerDetails = false;
        if (StringUtils.isNotBlank((String)conf.getServerName()) && conf.getServerPort() > 0) {
            try {
                new URL("http", conf.getServerName(), conf.getServerPort(), "");
                hasValidServerDetails = true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String propServerURL = "server-url";
        String url = prop.getProperty("server-url");
        if (StringUtils.isNotBlank((String)url)) {
            try {
                URL u = new URL(url);
                conf.setServerName(u.getHost());
                conf.setServerPort(u.getPort());
                hasValidServerDetails = true;
            }
            catch (MalformedURLException u) {
                // empty catch block
            }
        }
        if (!hasValidServerDetails) {
            UserClient.exitWithError(UserClient.format("missing-server-details", new String[0]), conf.isSilent());
        }
        if ("Y".equals(prop.getProperty("use-strict-ssl-verification"))) {
            conf.setUseStrictSSLVerification(true);
        }
        conf.setConnectionWatcherEnabled("Y".equals(prop.getProperty("connection-watcher-enabled", "Y")));
        if (!conf.isDebugEnabled()) {
            String debugProp = "debug";
            String[] debug = prop.getProperty("debug");
            if (StringUtils.isNotBlank((String)debug)) {
                conf.setDebugEnabled(StringDataUtils.stringToBoolean((String)debug, (boolean)false));
            }
        }
        if (conf.isDebugEnabled()) {
            UserClient.initLogging(true);
            UserClientConfig.determineOSUsername();
        }
        if (!conf.isUseStrictSSLVerification()) {
            try {
                NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors();
            }
            catch (GeneralSecurityException e) {
                logger.error("Invalid SSL Setup.", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting client version: {}", (Object)ApplicationInfo.getInstance().getDisplayVersionWithPlatformInfo());
            StringBuilder cmdString = new StringBuilder();
            for (String arg : args) {
                cmdString.append(arg).append(" ");
            }
            logger.debug("Command line options: {}", (Object)cmdString.toString());
            logger.debug("Initial config: {}", (Object)conf);
            logger.debug("System username: {}", (Object)System.getProperty("user.name"));
            logger.debug("Config username: {}", (Object)conf.getUserName());
            logger.debug("Locale: {}", (Object)Locale.getDefault());
            logger.debug("Max memory: {}", (Object)Formatter.formatNumber((double)((double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0), (int)1, (Locale)Locale.US));
            Thread activityLogger = UserClient.createActivityLoggerThread();
            activityLogger.start();
        }
        return conf;
    }

    private static Thread createActivityLoggerThread() {
        Thread activityLogger = new Thread("activity-logger"){
            private final long _started = System.currentTimeMillis();

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        Runtime runtime = Runtime.getRuntime();
                        long jvmMemoryUsedMB = (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
                        long jvmMemoryTotalMB = runtime.totalMemory() / 1024L / 1024L;
                        long jvmMemoryMaxMB = runtime.maxMemory() / 1024L / 1024L;
                        long uptimeMS = System.currentTimeMillis() - this._started;
                        logger.debug("Uptime: {} secs. Memory MB (used/total/max): {}/{}/{}", new Object[]{uptimeMS / 1000L, jvmMemoryUsedMB, jvmMemoryTotalMB, jvmMemoryMaxMB});
                    }
                }
                catch (InterruptedException e) {
                    logger.debug("Activity logger thread interrupted.");
                    logger.debug("Activity logger thread stopped.");
                    return;
                }
            }
        };
        activityLogger.setDaemon(true);
        return activityLogger;
    }

    private static CommandLine parseCommandLine(String[] argsIn) {
        CommandLine cmdLine;
        String[] args = new String[argsIn.length];
        for (int i = 0; i < argsIn.length; ++i) {
            Object arg = argsIn[i];
            if (((String)arg).startsWith("/") && StringUtils.countMatches((String)arg, (String)"/") == 1) {
                arg = "--" + ((String)arg).substring(1);
            }
            args[i] = arg;
        }
        Options options = new Options();
        options.addOption("s", "silent", false, "Indicates the client should close quietly on error.");
        options.addOption("b", "debug", false, "Enable debug logging.");
        options.addOption("m", "minimized", false, "Start the client minimized.");
        options.addOption("B", "hide-balance", false, "Hide the user balance.");
        options.addOption("n", "neverrequestidentity", false, "Never display the identity conformation dialog if user does not exist. Sleep instead.");
        options.addOption("a", "requestidentity", false, "Display the identity conformation dialog.");
        options.addOption("l", "multiple", false, "Allow more than one instance per user.");
        options.addOption("w", "standardwinlaf", false, "Use standard Windows look and feel.");
        options.addOption("q", "noquit", false, "Do not allow the user to quit/close the client.");
        options.addOption("I", "disabletasktrayicon", false, "Hide the task tray icon");
        options.addOption("O", "disable-toast-notifications", false, "Disable toast notifications");
        options.addOption("o", "disable-balloon-tips", false, "Disable balloon tips");
        options.addOption("K", "pre-authenticate", false, "Pre-authenticate a user given prior to starting");
        options.addOption("U", "use-pre-authentication", false, "Start client using the prior called pre-authentication");
        options.addOption("C", "clear-authentication", false, "Clear authentication then exit");
        options.addOption(UserClient.option("username", "The user to run the client as.", "user", "u"));
        options.addOption(UserClient.option("shared-secret-file", "Path to the shared secret file to use for pre-authentication", "shared-secret-file", "S"));
        options.addOption(UserClient.option("lockdir", "Define an alternate lock directory location", "lockdir", "d"));
        options.addOption(UserClient.option("accounts-file", "The path to the file containing shared account data from the server.", "accounts-file", "A"));
        options.addOption("AP", "accounts-file-disable-preload", false, "Stops file containing shared account data from the server from being automatically reloaded in the background.");
        options.addOption(UserClient.option("windowposition", "The location of the window (top-right, top-left, bottom-right, bottom-left).", "windowposition", "p"));
        options.addOption(UserClient.option("windowtitle", "The title to appear in the window.  If it includes the {0} placeholder, then this will be replaced by the user's username.", "windowtitle", "t"));
        options.addOption(UserClient.option("background-color", "The background color to use. In hexadecimal RGB, e.g. AA2400", "background-color", "k"));
        options.addOption(UserClient.option("text-color", "The text color to use. In hexadecimal RGB, e.g. AA2400", "text-color", "x"));
        options.addOption(UserClient.option("link-color", "The link color to use. In hexadecimal RGB, e.g. AA2400", "link-color", "i"));
        options.addOption(UserClient.option("link-hover-color", "The link mouseover color to use. In hexadecimal RGB, e.g. AA2400", "link-hover-color", "c"));
        options.addOption(UserClient.option("additional-link-color", "The color of the admin-defined link in the top right corner. In hexadecimal RGB, e.g. AA2400", "additional-link-color", "r"));
        options.addOption(UserClient.option("negative-balance-color", "The negative balance color to use. In hexadecimal RGB, e.g. AA2400", "negative-balance-color", "X"));
        options.addOption(UserClient.option("default-selection", "Specifies the default selected option on the account selection popup. (charge-personal, charge-account-list, charge-account-pin, print-as-user).", "default-selection", "f"));
        options.addOption(UserClient.option("default-account", "Specifies the default selected account on the account selection popup. Usually used in conjunction with default-selection=charge-account-list.", "default-account", "F"));
        options.addOption(UserClient.option("default-account-pin", "Specifies the default selected account pin on the account selection popup. Usually used in conjunction with default-selection=charge-account-pin.", "default-account-pin", "P"));
        options.addOption(UserClient.option("auth-ttl-values", "The list authentication time-to-live options (comma separated)", "auth-ttl-values", "T"));
        options.addOption(UserClient.option("auth-ttl-default", "The default authentication TTL to use", "auth-ttl-default", "D"));
        options.addOption(DISABLE_AUTH_BY_ID_NUMBER_CMD_LINE_ARG, DISABLE_AUTH_BY_ID_NUMBER_OPTION, false, "Disables authentication by ID Number if enabled in server.");
        options.addOption("h", "help", false, "Displays this help.");
        DefaultParser parser = new DefaultParser();
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            cmdLine = null;
        }
        if (cmdLine == null || cmdLine.hasOption("h")) {
            HelpFormatter hf = new HelpFormatter();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            hf.printHelp(pw, 100, "pc-client [options]", null, options, 1, 3, null, false);
            System.out.print(sw.toString());
            try {
                JOptionPane.showMessageDialog(null, sw.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(1);
        }
        return cmdLine;
    }

    private static Option option(String argName, String description, String longOpt, String shortOpt) {
        return Option.builder((String)shortOpt).hasArg().argName(argName).desc(description).longOpt(longOpt).build();
    }

    private static void initLogging(boolean enableDebug) {
        Properties logProps = new Properties();
        logProps.setProperty("appenders", "log");
        if (enableDebug) {
            String LOG_FILE_NAME = "user-client.log";
            String logPath = "user-client.log";
            File dir = SystemUtils.IS_OS_MAC_OSX ? new File(NetworkUtils.getUserHomeDirectory()) : new File(System.getProperty("java.io.tmpdir"));
            if (dir.exists() && dir.isDirectory()) {
                logPath = new File(dir, "user-client.log").getAbsolutePath();
            }
            logProps.setProperty("appender.log.type", "File");
            logProps.setProperty("appender.log.name", "Logger");
            logProps.setProperty("appender.log.fileName", logPath);
        } else {
            logProps.setProperty("appender.log.type", "Console");
            logProps.setProperty("appender.log.name", "Logger");
        }
        logProps.setProperty("appender.log.layout.type", "PatternLayout");
        logProps.setProperty("appender.log.layout.pattern", "%d{DEFAULT} %5p %c{1}:%L - %m [%t]%n");
        logProps.setProperty("rootLogger.level", "off");
        logProps.setProperty("rootLogger.appenderRef.log.ref", "Logger");
        if (StringUtils.isNotBlank((String)System.getProperty("papercut.dev-debug"))) {
            enableDebug = true;
        }
        String level = enableDebug ? "debug" : "off";
        logProps.setProperty("logger.biz-papercut.name", "biz.papercut");
        logProps.setProperty("logger.biz-papercut.level", level);
        logProps.setProperty("logger.com-papercut.name", "com.papercut");
        logProps.setProperty("logger.com-papercut.level", level);
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        PropertiesConfiguration config = new PropertiesConfigurationBuilder().setConfigurationSource(ConfigurationSource.NULL_SOURCE).setRootProperties(logProps).setLoggerContext(context).build();
        context.setConfiguration((Configuration)config);
        Configurator.initialize((Configuration)config);
    }

    private static void exitWithError(String msg, boolean silent) {
        logger.error("Exiting with error: {}", (Object)msg);
        if (!silent) {
            try {
                SwingUtilities.invokeAndWait(() -> DialogUtils.showErrorMessageDialog(null, (String)"", (String)msg));
            }
            catch (Exception e) {
                logger.error("Exiting with error: {}", (Object)msg);
            }
        }
        System.exit(1);
    }

    private static String format(String key, String ... args) {
        String fullKey = "UserClient." + key;
        return Messages.getString(UserClient.class, fullKey, args);
    }

    private static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.isEmpty()) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new RuntimeException("unbalanced quotes in " + toProcess);
        }
        return result.toArray(new String[0]);
    }
}

