/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.concurrent.Runnables;
import com.google.common.io.CharStreams;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MSWindowsUtils {
    private static final Logger logger = LoggerFactory.getLogger(MSWindowsUtils.class);
    private static boolean _initialised;
    private static boolean _initialiseFailed;

    private MSWindowsUtils() {
    }

    static boolean isWindows8OrHigher() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        String osVersion = SystemUtils.OS_VERSION;
        logger.info("Windows osVersion={}", (Object)osVersion);
        try {
            Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)$");
            Matcher m = p.matcher(osVersion);
            if (!m.matches()) {
                logger.debug("Windows version has unexpected format");
                return false;
            }
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            logger.debug("Windows version: major={},minor={}", (Object)major, (Object)minor);
            return major == 6 && minor >= 2 || major > 6;
        }
        catch (Exception e) {
            logger.debug("Unable to decode Windows version: error = {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private static void execToast(String cmd, String msg, String iconPath) {
        Runnables.startInDaemonThread((String)"exec-toast", () -> {
            try {
                logger.debug("Running Toast: cmd={}", (Object)cmd);
                logger.debug("msg='{}'", (Object)msg);
                String debugFlag = logger.isDebugEnabled() ? "--debug" : "";
                Process p = Runtime.getRuntime().exec(new String[]{cmd, iconPath, debugFlag});
                OutputStream stdin = p.getOutputStream();
                InputStream stderr = p.getErrorStream();
                try (BufferedWriter input = new BufferedWriter(new OutputStreamWriter(stdin, StandardCharsets.UTF_8));){
                    input.write(msg);
                }
                logger.debug("Toast stdin sent");
                int exitValue = p.waitFor();
                logger.debug("Toast exit value: {}", (Object)exitValue);
                if (exitValue < 0) {
                    String errorMessage = CharStreams.toString((Readable)new InputStreamReader(stderr, StandardCharsets.UTF_8));
                    logger.error("Toast failed: message= {}", (Object)errorMessage);
                }
            }
            catch (IOException e) {
                logger.debug("Unable to run Toast, error = {}", (Object)e.getMessage(), (Object)e);
            }
            catch (InterruptedException e) {
                logger.debug("InterruptedException running Toast, error = {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    static void sendWindows8Message(String msg) {
        String logoPath;
        String toastPath;
        if (StringUtils.isBlank((String)msg)) {
            throw new IllegalArgumentException("Invalid message");
        }
        File clientLibDir = new File(UserClientUtils.getHomeDirectory(), "lib");
        Object fullMsg = ApplicationInfo.getInstance().getApplicationName() + "\n" + msg;
        fullMsg = ((String)fullMsg).replaceAll("[\r\n]+", "\n");
        try {
            toastPath = new File(clientLibDir, "pc-toast-notify.exe").getCanonicalPath();
            logoPath = new File(clientLibDir, "icon-toast-notify.png").getCanonicalPath();
            URL customLogoUrl = UserClientUtils.getCustomIconImage();
            if (customLogoUrl != null && customLogoUrl.getProtocol().equalsIgnoreCase("file")) {
                logoPath = Paths.get(customLogoUrl.toURI()).toAbsolutePath().toString();
                logger.debug("Using custom icon image: {}", (Object)logoPath);
            } else {
                logger.debug("No customer logo defined. Using {}", (Object)logoPath);
            }
        }
        catch (IOException | URISyntaxException e) {
            logger.debug("Unable to construct toast command , error = {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        MSWindowsUtils.execToast(toastPath, (String)fullMsg, logoPath);
    }

    private static void sendWindows8PrintSystemAlert() {
        if (!MSWindowsUtils.isWindows8OrHigher()) {
            return;
        }
        String msg = Messages.getString(MSWindowsUtils.class, "MSWindowsUtils.print-system-alert", new String[0]);
        MSWindowsUtils.sendWindows8Message(msg);
    }

    static void addWindowListenerToBringWindowToFrontOnOpen(final Window window, final boolean showWindows8Alert) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (!MSWindowsUtils.forceWindowToTop(window, showWindows8Alert)) {
                    window.toFront();
                }
            }
        });
    }

    private static boolean forceWindowToTop(Window window, boolean showWindows8Alert) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        if (!MSWindowsUtils.ensureDllIsInitialised()) {
            return false;
        }
        MSWindowsUtils.forceWindowToTopInternal(window);
        if (showWindows8Alert) {
            MSWindowsUtils.sendWindows8PrintSystemAlert();
        }
        return true;
    }

    private static synchronized boolean ensureDllIsInitialised() {
        if (!_initialised && !_initialiseFailed) {
            try {
                File clientLibDir = new File(UserClientUtils.getHomeDirectory(), "lib");
                String clientDllPath = new File(clientLibDir, "clientjni.dll").getCanonicalPath();
                logger.debug("Loading dll: {}", (Object)clientDllPath);
                System.load(clientDllPath);
                File javaHomeBin = new File(System.getProperty("java.home"), "bin");
                File jawtDllFile = new File(javaHomeBin, "jawt.dll");
                String jawtDllPath = jawtDllFile.getCanonicalPath();
                if (!jawtDllFile.exists()) {
                    throw new ApplicationException("Cannot find jawt.dll here: " + jawtDllPath);
                }
                MSWindowsUtils.initialise(jawtDllPath);
                _initialised = true;
            }
            catch (Throwable t) {
                logger.error("Error loading clientjni.dll: {}", (Object)t.getMessage(), (Object)t);
                _initialiseFailed = true;
            }
        }
        return _initialised;
    }

    private static native void initialise(String var0);

    private static native void forceWindowToTopInternal(Window var0);
}

