/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.PropertiesUtils;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(ClientConfigFile.class);
    private static final String DEFAULT_CONFIG_NAME = "config.properties";
    private static final String MAC_USER_LEVEL_CONFIG_DIR = "Library/Preferences/PCClient";
    private static final String MAC_USER_LEVEL_CONFIG = "config.properties";
    private static final String GENERAL_USER_LEVEL_CONFIG = "pc-client.properties";
    private static final String AUTH_COOKIE_FILE_NAME = "pc-auth.cookie";

    private ClientConfigFile() {
    }

    static Properties loadConfig() {
        String configFileName = new File(UserClientUtils.getHomeDirectory(), "config.properties").getAbsolutePath();
        if (!new File(configFileName).exists() && new File("src/conf/config.properties").exists()) {
            configFileName = "src/conf/config.properties";
        }
        Properties prop = new Properties();
        try (FileInputStream fin = new FileInputStream(configFileName);){
            logger.debug("Reading configuration from file: " + configFileName);
            PropertiesUtils.loadProperties((InputStream)fin, (Properties)prop);
        }
        catch (Exception e) {
            logger.error("Unable to read config file: " + configFileName, (Throwable)e);
            throw new ApplicationException("Unable to read default config file", (Throwable)e);
        }
        File userLevelConfigFile = ClientConfigFile.getUserLevelConfigFile();
        Properties userProp = new Properties();
        if (userLevelConfigFile != null && userLevelConfigFile.exists()) {
            ClientConfigFile.loadUserLevelConfigFile(userLevelConfigFile, userProp);
            prop.putAll((Map<?, ?>)userProp);
        }
        return prop;
    }

    private static void savePropToUserLevelConfig(String propName, String propValue) {
        File userLevelConfigFile = ClientConfigFile.getUserLevelConfigFile();
        logger.debug("Saving \"" + propName + "\"=\"" + propValue + "\" to: " + userLevelConfigFile);
        Properties userProp = new Properties();
        if (userLevelConfigFile.exists()) {
            logger.debug("Update existing properties file: " + userLevelConfigFile);
            ClientConfigFile.loadUserLevelConfigFile(userLevelConfigFile, userProp);
            userProp.setProperty(propName, propValue);
            try {
                PropertiesUtils.saveUpdatedProperties((String)userLevelConfigFile.getPath(), (Properties)userProp);
            }
            catch (IOException e) {
                throw new ApplicationException("Unable to save user level config file", (Throwable)e);
            }
        }
        try {
            File parentDir = userLevelConfigFile.getParentFile();
            parentDir.mkdirs();
        }
        catch (Exception parentDir) {
            // empty catch block
        }
        PrintWriter file = null;
        try {
            file = new PrintWriter(PropertiesUtils.createFileWriter((File)userLevelConfigFile));
            file.println("#" + ApplicationInfo.getInstance().getApplicationName() + " User-level Client Config");
            file.println(propName + "=" + propValue);
        }
        catch (IOException e) {
            try {
                String errMsg = "Unable to write user level config file to: " + userLevelConfigFile.getPath();
                logger.error(errMsg, (Throwable)e);
                throw new ApplicationException(errMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)file);
    }

    static void saveUsernameToUserLevelConfig(String newUserName) {
        ClientConfigFile.savePropToUserLevelConfig("user", newUserName);
    }

    static void saveServerPortToUserLevelConfig(String newPort) {
        ClientConfigFile.savePropToUserLevelConfig("server-port", newPort);
    }

    private static File getUserLevelConfigDirectory() {
        String homeDir = NetworkUtils.getUserHomeDirectory();
        if (SystemUtils.IS_OS_MAC_OSX) {
            return new File(homeDir, MAC_USER_LEVEL_CONFIG_DIR);
        }
        return new File(homeDir);
    }

    private static File getUserLevelConfigFile() {
        File userConfDir = ClientConfigFile.getUserLevelConfigDirectory();
        File userLevelConfigFile = SystemUtils.IS_OS_MAC_OSX ? new File(userConfDir, "config.properties") : new File(userConfDir, GENERAL_USER_LEVEL_CONFIG);
        return userLevelConfigFile;
    }

    private static void loadUserLevelConfigFile(File file, Properties prop) {
        FileInputStream fin = null;
        try {
            logger.debug("Reading user level configuration from file: " + file.getPath());
            fin = new FileInputStream(file);
            PropertiesUtils.loadProperties((InputStream)fin, (Properties)prop);
        }
        catch (Exception e) {
            try {
                String errMsg = "Unable to read user level config file: " + file.getPath();
                logger.error(errMsg, (Throwable)e);
                throw new ApplicationException(errMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String loadUserAuthCookie() {
        File authFile = new File(ClientConfigFile.getUserLevelConfigDirectory(), AUTH_COOKIE_FILE_NAME);
        if (!authFile.exists() || !authFile.isFile()) {
            return null;
        }
        String cookie = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(authFile);
            Properties p = new Properties();
            p.load(fin);
            cookie = p.getProperty("cookie");
        }
        catch (IOException e) {
            try {
                logger.error("Failed to read auth cookie from file: " + authFile + ". " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
        return StringUtils.trimToNull(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveUserAuthCookie(String authCookie) {
        FileOutputStream fout;
        if (logger.isDebugEnabled()) {
            logger.debug("Saving auth cookie: " + authCookie);
        }
        if ((authCookie = StringUtils.trimToEmpty((String)authCookie)).length() == 0) {
            return;
        }
        File userConfDir = ClientConfigFile.getUserLevelConfigDirectory();
        if (!userConfDir.exists()) {
            userConfDir.mkdirs();
        }
        File authFile = new File(userConfDir, AUTH_COOKIE_FILE_NAME);
        if (SystemUtils.IS_OS_UNIX && !authFile.exists()) {
            fout = null;
            try {
                fout = new FileOutputStream(authFile);
                IOUtils.closeQuietly((OutputStream)fout);
                new ProcessBuilder("chmod", "600", authFile.getAbsolutePath()).start();
            }
            catch (Exception e) {
                try {
                    logger.error("Problem setting up auth cookie file permissions. " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fout);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fout);
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        fout = null;
        try {
            Properties p = new Properties();
            p.setProperty("cookie", authCookie);
            fout = new FileOutputStream(authFile);
            p.store(fout, "");
            fout.flush();
        }
        catch (IOException ioe) {
            try {
                logger.error("Unable to save auth cookie file: " + authFile.getPath() + ". " + ioe.getMessage(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }

    static void deleteUserAuthCookie() {
        File authFile = new File(ClientConfigFile.getUserLevelConfigDirectory(), AUTH_COOKIE_FILE_NAME);
        if (authFile.exists()) {
            authFile.delete();
        }
    }
}

