/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.BrowserLinkUtils;
import biz.papercut.pcng.util.swing.FadeImage;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMacClientFrame
extends UserClientFrame {
    private static final Logger logger = LoggerFactory.getLogger(UserMacClientFrame.class);
    private JPopupMenu _macPopupMenu;
    private TrayIcon _macTrayIcon;
    private AWTEventListener _macPopupAWTEventListener;
    private final Timer _popupTimer = new Timer();
    private TimerTask _popupLastTask;
    private static final short CLOSE_TIMEOUT = 2000;
    private static final String WINDOW_CLOSE_KEY_EVENT = "window_close";
    private static final String WINDOW_QUIT_KEY_EVENT = "window_quit";
    private static final String REFRESH_ICON_RETINA = "images/client-refresh@2x.png";
    public static final String CLIENT_LOGO_RETINA = "images/client-icon@2x.png";

    UserMacClientFrame() {
    }

    private synchronized boolean cancelLastTask() {
        if (this._popupLastTask != null) {
            boolean b = this._popupLastTask.cancel();
            this._popupLastTask = null;
            return b;
        }
        return true;
    }

    private synchronized void scheduleNewTask() {
        this._popupLastTask = new TimerTask(){

            @Override
            public void run() {
                UserMacClientFrame.this.unshowPopup();
            }
        };
        try {
            this._popupTimer.schedule(this._popupLastTask, 2000L);
        }
        catch (Throwable t) {
            logger.error("Unable to schedule close popup task", t);
        }
    }

    private void armPopup() {
        if (this._macPopupMenu != null && this._macPopupAWTEventListener == null) {
            this._macPopupAWTEventListener = event -> {
                WindowEvent we;
                MouseEvent m;
                if (event instanceof MouseEvent && (m = (MouseEvent)event).getID() == 500 && m.getButton() != 3) {
                    this.unshowPopup();
                }
                if (event instanceof WindowEvent && ((we = (WindowEvent)event).getID() == 206 || we.getID() == 209 || we.getID() == 207 || we.getID() == 208)) {
                    this.unshowPopup();
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this._macPopupAWTEventListener, 80L);
        }
    }

    @Override
    WindowListener getWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (UserMacClientFrame.this.hasTaskTray()) {
                    UserMacClientFrame.this.setVisible(false);
                } else {
                    UserMacClientFrame.this.setState(1);
                }
            }
        };
    }

    @Override
    void addWindowKeyEvents() {
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), WINDOW_CLOSE_KEY_EVENT);
        this.getRootPane().getActionMap().put(WINDOW_CLOSE_KEY_EVENT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserMacClientFrame.this.getWindowListeners()[0] != null) {
                    UserMacClientFrame.this.getWindowListeners()[0].windowClosing(new WindowEvent(UserMacClientFrame.this, 201));
                }
            }
        });
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), WINDOW_QUIT_KEY_EVENT);
        this.getRootPane().getActionMap().put(WINDOW_QUIT_KEY_EVENT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserMacClientFrame.this.exitIfAllowed();
            }
        });
    }

    @Override
    void setupTaskTray() {
        if (!SystemTray.isSupported()) {
            logger.info("System tray is not supported in the environment that you use: " + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION);
            return;
        }
        try {
            logger.debug("Setting up task tray");
            String imgSrc = UserMacClientFrame.getTrayOnlineIconPath();
            ImageIcon image = this.createImageIcon(imgSrc);
            this._macTrayIcon = new TrayIcon(image.getImage());
            this._macTrayIcon.addMouseListener(new TrayIconListener());
            this._macTrayIcon.setToolTip(UserMacClientFrame.getMessage("connecting"));
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this._macTrayIcon);
        }
        catch (Throwable t) {
            logger.error("Error setting up task tray", t);
            this._macTrayIcon = null;
        }
    }

    private static boolean isInDarkMode() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
            p.waitFor(100L, TimeUnit.MILLISECONDS);
            return p.exitValue() == 0;
        }
        catch (IOException | IllegalThreadStateException | InterruptedException e) {
            return false;
        }
    }

    private static String getTrayOnlineIconPath() {
        return UserMacClientFrame.isInDarkMode() ? "images/client-mac-tray-icon-dm-1024x1024.png" : "images/client-mac-tray-icon-1024x1024.png";
    }

    private static String getTrayOfflineIconPath() {
        return UserMacClientFrame.isInDarkMode() ? "images/client-mac-offline-tray-icon-dm-1024x1024.png" : "images/client-mac-offline-tray-icon-1024x1024.png";
    }

    @Override
    void buildMenus() {
        if (logger.isDebugEnabled()) {
            logger.debug("Building popup menu. Config: " + this._config);
        }
        if (this.getPopupMenu() == null) {
            this._macPopupMenu = new JPopupMenu("Tray Icon Menu");
            this.getPopupMenu().addMouseListener(new MacPopupMenuListener());
        }
        this.getPopupMenu().removeAll();
        JMenuItem openItem = new JMenuItem(UserMacClientFrame.getMessage("open"));
        openItem.addActionListener(evt -> this.makeVisible());
        openItem.addMouseListener(new MenuItemListener());
        openItem.setOpaque(true);
        if (this._config != null && this._config.getServerUserConfig().isShowBalance()) {
            logger.debug("Show balance, add open item");
            this.getPopupMenu().add(openItem);
        }
        if (this._config != null) {
            if (this._config.isCurrentlyAuthenticated()) {
                logger.debug("Currently authenticated, add logout menu");
                JMenuItem logout = new JMenuItem(UserMacClientFrame.getMessage("logout"));
                logout.addActionListener(evt -> this.doLogout());
                logout.setOpaque(true);
                logout.addMouseListener(new MenuItemListener());
                this.getPopupMenu().add(logout);
            }
            if (this._config.getServerUserConfig().isUnauthenticatedUser()) {
                logger.debug("Unauthenticated, add login as menu");
                JMenuItem login = new JMenuItem(UserMacClientFrame.getMessage("login-as"));
                login.addActionListener(evt -> {
                    ClientConfigFile.deleteUserAuthCookie();
                    this.doLogin();
                });
                login.setOpaque(true);
                login.addMouseListener(new MenuItemListener());
                this.getPopupMenu().add(login);
            }
            if (this._config.getServerGlobalConfig().isShowDetailsLink() && StringUtils.isNotBlank((String)this._config.getUserPageURL())) {
                JMenuItem userDetailsItem = new JMenuItem(UserMacClientFrame.getMessage("user-details"));
                userDetailsItem.addActionListener(evt -> BrowserLinkUtils.openBrowser((String)this.getUserDetailsURLLink()));
                userDetailsItem.setOpaque(true);
                userDetailsItem.addMouseListener(new MenuItemListener());
                this.getPopupMenu().add(userDetailsItem);
            }
            if (this._config.getServerGlobalConfig().isShowLink() && StringUtils.isNotBlank((String)this._config.getServerGlobalConfig().getLinkURL()) && StringUtils.isNotBlank((String)this._config.getServerGlobalConfig().getLinkText())) {
                JMenuItem linkItem = new JMenuItem(this._config.getServerGlobalConfig().getLinkText());
                linkItem.addActionListener(evt -> BrowserLinkUtils.openBrowser((String)this._config.getServerGlobalConfig().getLinkURL()));
                linkItem.setOpaque(true);
                linkItem.addMouseListener(new MenuItemListener());
                this.getPopupMenu().add(linkItem);
            }
        }
        if (this.getPopupMenu().getComponents().length > 0) {
            this.getPopupMenu().addSeparator();
        }
        JMenuItem exitItem = new JMenuItem(UserMacClientFrame.getMessage("exit"));
        exitItem.addActionListener(evt -> {
            logger.debug("User select 'Exit'");
            this.exitIfAllowed();
        });
        exitItem.setOpaque(true);
        exitItem.addMouseListener(new MenuItemListener());
        this.getPopupMenu().add(exitItem);
    }

    @Override
    JPopupMenu getPopupMenu() {
        return this._macPopupMenu;
    }

    @Override
    public void setTaskTrayToolTip(String text) {
        if (this._macTrayIcon != null) {
            this._macTrayIcon.setToolTip(text);
        }
    }

    @Override
    boolean hasTaskTray() {
        return this._macTrayIcon != null;
    }

    @Override
    void removeTaskTray() {
        if (this.hasTaskTray()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            systemTray.remove(this._macTrayIcon);
        }
    }

    private synchronized void unshowPopup() {
        if (this._macPopupMenu.isShowing()) {
            MenuElement[] mes = this._macPopupMenu.getSubElements();
            if (mes != null) {
                for (MenuElement me : mes) {
                    me.getComponent().setBackground(UIManager.getColor("MenuItem.background"));
                    me.getComponent().setForeground(UIManager.getColor("MenuItem.foreground"));
                }
            }
            this._macPopupMenu.setVisible(false);
            this.cancelLastTask();
            this._popupTimer.purge();
        }
    }

    @Override
    public void setOfflineIcon(boolean offline) {
        String imgSrc = offline ? UserMacClientFrame.getTrayOfflineIconPath() : UserMacClientFrame.getTrayOnlineIconPath();
        ImageIcon image = this.createImageIcon(imgSrc);
        if (this.hasTaskTray()) {
            this._macTrayIcon.setImage(image.getImage());
            if (offline) {
                this.setTaskTrayToolTip(UserMacClientFrame.getMessage("offline"));
            } else {
                this.restoreLastToolTipCreditText();
            }
        }
    }

    @Override
    public ImageIcon createRefreshImageIcon() {
        if (UserClientUtils.hasRetinaDisplay()) {
            URL imgURL = this.getClass().getResource(REFRESH_ICON_RETINA);
            return UserClientUtils.createRetinaImageIcon(imgURL);
        }
        return super.createRefreshImageIcon();
    }

    @Override
    public void scaleRefreshImageIcon(JLabel refreshImage) {
        if (UserClientUtils.hasRetinaDisplay()) {
            refreshImage.setBounds(195, 10, 20, 20);
        } else {
            super.scaleRefreshImageIcon(refreshImage);
        }
    }

    @Override
    public void setLogoBounds(JComponent logoImage, boolean isPaperCutLogo) {
        if (this.shouldAddRetinaSupport(isPaperCutLogo)) {
            logoImage.setBounds(5, 9, 64, 81);
        } else {
            super.setLogoBounds(logoImage, isPaperCutLogo);
        }
    }

    private boolean shouldAddRetinaSupport(boolean isPaperCutLogo) {
        return isPaperCutLogo && UserClientUtils.hasRetinaDisplay() && !SystemUtils.IS_JAVA_1_4;
    }

    @Override
    public JComponent createLogoImage(URL logoURL, boolean isPaperCutLogo) {
        if (this.shouldAddRetinaSupport(isPaperCutLogo)) {
            try {
                URL retinaLogoURL = this.getResourceLogo(CLIENT_LOGO_RETINA);
                FadeImage fadeImage = new FadeImage(retinaLogoURL, 0.0f);
                fadeImage.setRetinaSupport(true);
                return fadeImage;
            }
            catch (Exception e) {
                logger.error("Problem loading logo retina image. Falling back to standard logo image.");
            }
        }
        return super.createLogoImage(logoURL, isPaperCutLogo);
    }

    class MenuItemListener
    extends MouseAdapter {
        MenuItemListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenuItem jMenuItem = (JMenuItem)e.getSource();
            jMenuItem.setBackground(UIManager.getColor("MenuItem.background"));
            jMenuItem.setForeground(UIManager.getColor("MenuItem.foreground"));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenuItem jMenuItem = (JMenuItem)e.getSource();
            jMenuItem.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
            jMenuItem.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
        }
    }

    class TrayIconListener
    extends ArmPopupListener {
        TrayIconListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleTrayEvent(e);
            super.mousePressed(e);
        }

        private void handleTrayEvent(MouseEvent e) {
            if (this.shouldMakeVisible()) {
                if (e.getButton() == 1) {
                    UserMacClientFrame.this.makeVisible();
                } else if (e.getButton() == 3) {
                    UserMacClientFrame.this.cancelLastTask();
                    UserMacClientFrame.this.scheduleNewTask();
                }
            }
        }

        private boolean shouldMakeVisible() {
            return UserMacClientFrame.this._config != null && UserMacClientFrame.this._config.getServerUserConfig().isShowBalance();
        }
    }

    class MacPopupMenuListener
    extends MouseAdapter {
        MacPopupMenuListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            boolean b = UserMacClientFrame.this.cancelLastTask();
            UserMacClientFrame.this.scheduleNewTask();
            if (logger.isDebugEnabled()) {
                logger.debug("Popup Mouse exited" + (!b ? ", Unable to cancel last task." : "."));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            boolean b = UserMacClientFrame.this.cancelLastTask();
            if (logger.isDebugEnabled()) {
                logger.debug("Popup Mouse entered" + (!b ? ", Unable to cancel last task." : "."));
            }
        }
    }

    class ArmPopupListener
    extends UserClientFrame.PopupListener {
        ArmPopupListener() {
        }

        @Override
        void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (!UserMacClientFrame.this._macPopupMenu.isVisible()) {
                    UserMacClientFrame.this.armPopup();
                }
                super.maybeShowPopup(e);
            }
        }
    }
}

