/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean containsAny(@Nullable String str, @Nullable String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return false;
        }
        for (String searchStr : searchStrs) {
            if (!org.apache.commons.lang.StringUtils.contains((String)str, (String)searchStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(@Nullable String str, @Nullable String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return false;
        }
        for (String searchStr : searchStrs) {
            if (!org.apache.commons.lang.StringUtils.containsIgnoreCase((String)str, (String)searchStr)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String lowerCaseUS(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.US);
    }

    public static List<String> csvToList(@Nullable String csv) {
        if (csv == null) {
            return Collections.emptyList();
        }
        String[] csvArray = csv.split(",");
        ArrayList<String> csvList = new ArrayList<String>(csvArray.length);
        for (String s : csvArray) {
            String value = org.apache.commons.lang.StringUtils.trimToNull((String)s);
            if (value == null) continue;
            csvList.add(value);
        }
        return csvList;
    }

    @NotNull
    public static String escapeHtml(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return "";
        }
        StringBuilder escaped = new StringBuilder();
        block6: for (char character : str.toCharArray()) {
            switch (character) {
                case '<': {
                    escaped.append("&lt;");
                    continue block6;
                }
                case '>': {
                    escaped.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    escaped.append("&quot;");
                    continue block6;
                }
                case '&': {
                    escaped.append("&amp;");
                    continue block6;
                }
                default: {
                    escaped.append(character);
                }
            }
        }
        return escaped.toString();
    }

    public static String shortenDocName(String docName, int maxLength, int noOfTrailingChars) {
        if (docName == null) {
            return null;
        }
        int len = docName.length();
        if (len > maxLength) {
            return docName.substring(0, maxLength - noOfTrailingChars - 3) + " ... " + docName.substring(len - noOfTrailingChars);
        }
        return docName;
    }

    public static String shortenDocName(String docName) {
        int maxDocLength = 40;
        int noOfEndChars = 20;
        return StringUtils.shortenDocName(docName, 40, 20);
    }
}

