/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memoizer {
    private static final Logger logger = LoggerFactory.getLogger(Memoizer.class);

    public static <I, O> Function<I, O> memoize(Function<I, O> func) {
        Cache lookup = Memoizer.cacheBuilder().build();
        return Memoizer.memoize(func, lookup);
    }

    public static <I, O> Function<I, O> memoize(Function<I, O> func, long duration, TimeUnit unit) {
        return Memoizer.memoize(func, duration, unit, Ticker.systemTicker());
    }

    static <I, O> Function<I, O> memoize(Function<I, O> func, long duration, TimeUnit unit, Ticker ticker) {
        Cache lookup = Memoizer.cacheBuilder().ticker(ticker).expireAfterWrite(duration, unit).build();
        return Memoizer.memoize(func, lookup);
    }

    private static <I, O> Function<I, O> memoize(Function<I, O> func, Cache<I, O> lookup) {
        return input -> {
            lookup.cleanUp();
            return lookup.asMap().computeIfAbsent(input, func);
        };
    }

    private static <I, O> CacheBuilder<I, O> cacheBuilder() {
        return CacheBuilder.newBuilder().removalListener(notification -> logger.trace("Removing cached result for mapping '{}' -> '{}': {}", new Object[]{notification.getKey().getClass().getSimpleName(), notification.getValue().getClass().getSimpleName(), notification.getKey()}));
    }
}

