/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.Formatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWatch {
    private static final Logger logger = LoggerFactory.getLogger(StopWatch.class);
    private static final boolean DEBUG_MODE = false;
    @Nullable
    private String _sessionName = "Stop watch";
    private final boolean _collectMemoryStats;
    private long _startTime = -1L;
    private long _stopTime = -1L;
    private final List<Split> _splits = new ArrayList<Split>();
    private final boolean _enabled;

    public StopWatch(@Nullable String sessionName) {
        this._sessionName = sessionName;
        this._enabled = System.getProperty("pc.debug.timing-enabled") != null;
        this._collectMemoryStats = System.getProperty("pc.debug.timing-collect-mem-stats") != null;
    }

    public StopWatch(@Nullable String sessionName, boolean enabled, boolean collectMemoryStats) {
        this._sessionName = sessionName;
        this._enabled = enabled;
        this._collectMemoryStats = collectMemoryStats;
    }

    public synchronized void start() {
        this._stopTime = -1L;
        this._startTime = System.currentTimeMillis();
    }

    public final boolean isEnabled() {
        return this._enabled;
    }

    public synchronized void stop() {
        this._stopTime = System.currentTimeMillis();
    }

    public synchronized long split(String name) {
        Split split;
        if (!this._enabled) {
            return 0L;
        }
        if (this._startTime < 0L) {
            throw new IllegalStateException("Can't do a split without calling start first.");
        }
        long lastSplitTime = this._splits.size() > 0 ? this._splits.get(this._splits.size() - 1).getActualTime() : this._startTime;
        long now = System.currentTimeMillis();
        long splitTime = now - lastSplitTime;
        if (this._collectMemoryStats) {
            Runtime r = Runtime.getRuntime();
            split = new Split(name, splitTime, now, r.freeMemory(), r.totalMemory());
        } else {
            split = new Split(name, splitTime, now);
        }
        this._splits.add(split);
        return split.getSplitTime();
    }

    public synchronized long getTime() {
        if (this._stopTime != -1L) {
            return this._stopTime - this._startTime;
        }
        return System.currentTimeMillis() - this._startTime;
    }

    public void logResultsIfEnabled(@Nullable Logger logger) {
        if (this._enabled && logger != null && logger.isInfoEnabled()) {
            logger.info(this.toString());
        }
    }

    public String toString() {
        if (!this._enabled) {
            return "StopWatch not enabled";
        }
        long elapsed = this.getTime();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)this._sessionName)) {
            sb.append("StopWatch session: ").append(this._sessionName).append("\n");
        }
        if (this._splits.size() > 0) {
            sb.append("Splits:\n");
        }
        for (Split split : this._splits) {
            sb.append("  ");
            sb.append(" Time (ms): ").append(StringUtils.leftPad((String)String.valueOf(split.getSplitTime()), (int)7));
            sb.append(" - ").append(split.getName());
            if (this._collectMemoryStats) {
                sb.append("   ");
                sb.append(" Free: ").append(Formatter.formatNumber((double)split.getFreeMem() / 1024.0 / 1024.0, 2, null));
                sb.append(" Max: ").append(Formatter.formatNumber((double)split.getTotalMem() / 1024.0 / 1024.0, 2, null));
            }
            sb.append("\n");
        }
        sb.append("Elapsed: ").append(elapsed);
        return sb.toString();
    }

    private static class Split {
        private final String _name;
        private final long _splitTime;
        private final long _actualTime;
        private long _freeMem;
        private long _totalMem;

        private Split(String name, long splitTime, long actualTime) {
            this._name = name;
            this._splitTime = splitTime;
            this._actualTime = actualTime;
        }

        private Split(String name, long splitTime, long actualTime, long freeMem, long totalMem) {
            this(name, splitTime, actualTime);
            this._freeMem = freeMem;
            this._totalMem = totalMem;
        }

        public String getName() {
            return this._name;
        }

        public long getSplitTime() {
            return this._splitTime;
        }

        public final long getActualTime() {
            return this._actualTime;
        }

        public long getFreeMem() {
            return this._freeMem;
        }

        public long getTotalMem() {
            return this._totalMem;
        }

        public String toString() {
            return "Split : " + this._name + " Time: " + this._splitTime;
        }
    }
}

