/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.SwingUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.apache.xmlrpc.XmlRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressTester {
    private static final Logger logger = LoggerFactory.getLogger(StressTester.class);
    private static final int BALANCE_CHECK_WAIT_MS = 1000;

    public static void main(String[] args) {
        Preconditions.checkArgument((args.length > 1 ? 1 : 0) != 0, (Object)"No arguments provided");
        StressTester.configureLogging(args[args.length - 1]);
        try {
            if (args.length < 3) {
                logger.error("Usage: --stress-test ServerIP NumThreads  [TestUserPrefix] [ServerPort] [TimeoutSecs]  [\"Debug\"]");
            }
            String serverIP = args[1];
            int numThreads = Integer.parseInt(args[2]);
            String tempPrefix = "testuser";
            if (args.length > 3) {
                tempPrefix = args[3];
            }
            String prefix = tempPrefix;
            int tempServerPort = 9191;
            if (args.length > 4) {
                tempServerPort = Integer.parseInt(args[4]);
            }
            int serverPort = tempServerPort;
            int tempTimeoutSecs = 90;
            if (args.length > 5) {
                tempTimeoutSecs = Integer.parseInt(args[5]);
            }
            int timeoutSecs = tempTimeoutSecs;
            System.getProperties().put("http.proxySet", "false");
            System.getProperties().put("http.proxyHost", "");
            System.getProperties().put("http.proxyPort", "");
            AtomicLong counter = new AtomicLong();
            try {
                SwingUtils.setupSystemLookAndFeel();
                SwingUtilities.invokeLater(() -> {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    DialogUtils.showInformationMessageDialog(null, (String)"Stress Tester", (String)("The stress tester is in progress.\nSimulating " + numThreads + " client connections.\nPress OK to end test."));
                    long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    System.out.println(counter.get() + " operations in " + elapsed + "ms: " + counter.get() * 1000L * 60L / elapsed + " ops/min");
                    System.exit(0);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            XmlRpc.setMaxThreads((int)((int)((double)numThreads * 1.2)));
            logger.info("Starting {} threads...", (Object)numThreads);
            for (int i = 0; i < numThreads; ++i) {
                String userName = prefix + i;
                Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
                new Thread(() -> {
                    try {
                        StressTester.serverActions(serverIP, serverPort, timeoutSecs, counter, userName);
                    }
                    catch (Throwable t) {
                        logger.error("Server connection failed: {} to {}:{}", new Object[]{userName, serverIP, serverPort, t});
                    }
                }).start();
            }
        }
        catch (Throwable t) {
            logger.error("Execution failed", t);
        }
    }

    static void serverActions(String serverIP, int serverPort, int timeoutSecs, AtomicLong counter, String userName) {
        logger.info("Creating server connection: {} to {}:{} with timeout: {}s", new Object[]{userName, serverIP, serverPort, timeoutSecs});
        ServerConnection connection = new ServerConnection(serverIP, serverIP, serverPort, timeoutSecs, false, false);
        connection.setUserName(userName);
        while (true) {
            try {
                while (true) {
                    logger.debug("calling getPendingActions (user={})", (Object)userName);
                    long requestsMade = counter.incrementAndGet();
                    if (requestsMade % 100L == 0L) {
                        logger.info("requests made: {}", (Object)requestsMade);
                    }
                    StressTester.runClientActions(connection, timeoutSecs, userName);
                }
            }
            catch (Exception e) {
                long delayMillis = 15000 + ThreadLocalRandom.current().nextInt(Math.max(30, timeoutSecs) * 1000);
                logger.error("Server connection failed: {} to {}:{}", new Object[]{userName, serverIP, serverPort, e});
                Uninterruptibles.sleepUninterruptibly((long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            break;
        }
    }

    private static void runClientActions(ServerConnection connection, int timeoutSecs, String userName) {
        long startTime = System.currentTimeMillis();
        List<ClientAction> actions = connection.getPendingActions(timeoutSecs);
        logger.debug("called getPendingActions (user={}): {} actions [{}ms]", new Object[]{userName, actions.size(), System.currentTimeMillis() - startTime});
        if (actions.isEmpty()) {
            long sleepFor = ThreadLocalRandom.current().nextLong(1000L);
            logger.debug("Random sleep for {}ms", (Object)sleepFor);
            Uninterruptibles.sleepUninterruptibly((long)sleepFor, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        for (ClientAction action : actions) {
            switch (action) {
                case UserMessages: {
                    Vector<String> messages = connection.getPendingMessages();
                    logger.debug("got {} messages", (Object)messages.size());
                    break;
                }
                case PrintJobs: {
                    List<ClientPrintJob> jobs = connection.getPendingPrintJobs();
                    logger.debug("got {} jobs", (Object)jobs.size());
                    break;
                }
                case BalanceUpdate: {
                    Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    String balance = connection.getUserBalance(userName);
                    logger.debug("got balance {}", (Object)balance);
                    break;
                }
                case AuthenticationExpired: {
                    logger.debug("got auth expired");
                    break;
                }
                case AuthenticationRequested: {
                    logger.debug("got auth requested");
                    break;
                }
                case DialogRequest: {
                    logger.debug("got dialog request");
                }
            }
        }
    }

    private static void configureLogging(String logLevel) {
        if (System.getProperty("log4j.configuration") != null) {
            logger.info("Using custom log4j configuration");
            return;
        }
        Properties logProps = new Properties();
        logProps.setProperty("appenders", "log, stdout");
        String LOG_FILE_NAME = "stress-test.log";
        logProps.setProperty("appender.log.type", "File");
        logProps.setProperty("appender.log.name", "FileLogger");
        logProps.setProperty("appender.log.fileName", new File(LOG_FILE_NAME).getAbsolutePath());
        logProps.setProperty("appender.log.layout.type", "PatternLayout");
        logProps.setProperty("appender.log.layout.pattern", "%d{ISO8601} %5p %c{1}:%L - %m%n");
        logProps.setProperty("appender.stdout.type", "Console");
        logProps.setProperty("appender.stdout.name", "ConsoleLogger");
        logProps.setProperty("appender.stdout.layout.type", "PatternLayout");
        logProps.setProperty("appender.stdout.layout.pattern", "%d{DEFAULT} %5p %c{1}:%L - %m [%t]%n");
        logProps.setProperty("rootLogger.level", "off");
        logProps.setProperty("rootLogger.appenderRef.log.ref", "FileLogger");
        logProps.setProperty("rootLogger.appenderRef.stdout.ref", "ConsoleLogger");
        logProps.setProperty("logger.biz-papercut.name", "biz.papercut");
        logProps.setProperty("logger.com-papercut.name", "com.papercut");
        if (logLevel.equalsIgnoreCase("debug")) {
            logProps.setProperty("logger.biz-papercut.level", "debug");
            logProps.setProperty("logger.com-papercut.level", "debug");
        } else {
            logProps.setProperty("logger.biz-papercut.level", "info");
            logProps.setProperty("logger.com-papercut.level", "info");
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        PropertiesConfiguration config = new PropertiesConfigurationBuilder().setConfigurationSource(ConfigurationSource.NULL_SOURCE).setRootProperties(logProps).setLoggerContext(context).build();
        context.setConfiguration((Configuration)config);
        Configurator.initialize((Configuration)config);
        logger.info("Configured logging");
    }
}

