/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.Checksum;
import biz.papercut.pcng.util.MessageReceiver;
import biz.papercut.pcng.util.ObjectUtils;
import biz.papercut.pcng.util.StopWatch;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class TaskStatus
implements MessageReceiver {
    private static final int MAX_MESSAGE_SIZE = 500000;
    private static int _currentTaskCounter;
    private final StringBuffer _messageBuffer = new StringBuffer();
    private boolean _complete = false;
    private boolean _receiverFull = false;
    @Nullable
    private final String _taskName;
    private final Date _startTime = new Date();
    private final String _taskID;
    private boolean readOnly = false;
    private final boolean _outputTiming;
    @Nullable
    private final StopWatch _stopWatch;

    public TaskStatus(@Nullable String taskName, @Nullable String taskID) {
        this._taskID = StringUtils.isBlank((String)taskID) ? TaskStatus.getUniqueTaskID() : taskID;
        this._taskName = taskName;
        this._outputTiming = StringUtils.isNotBlank((String)System.getProperty("papercut.debug.task-timing"));
        if (this._outputTiming) {
            this._stopWatch = new StopWatch(taskName, true, false);
            this._stopWatch.start();
        } else {
            this._stopWatch = null;
        }
    }

    public TaskStatus(String taskName) {
        this(taskName, null);
    }

    public TaskStatus() {
        this(null, null);
    }

    public static synchronized String getUniqueTaskID() {
        if (++_currentTaskCounter > 1000) {
            _currentTaskCounter = 0;
        }
        String idToHash = System.currentTimeMillis() + "-" + _currentTaskCounter;
        return Checksum.getMD5Sum(idToHash);
    }

    @Override
    public void setMessage(String message) {
        this.appendStatusMessage(message);
    }

    public synchronized void appendStatusMessage(String message) {
        if (this._outputTiming) {
            Preconditions.checkState((this._stopWatch != null ? 1 : 0) != 0);
            this._stopWatch.split(message);
        }
        if (this._messageBuffer.length() < 500000) {
            this._messageBuffer.append(message).append("\r\n");
        } else {
            if (!this._receiverFull) {
                this._messageBuffer.append("Task status too long. Unable to display further status messages!\r\n");
            }
            this._receiverFull = true;
        }
    }

    public synchronized String getStatusMessage() {
        return this._messageBuffer.toString();
    }

    public synchronized boolean isComplete() {
        return this._complete;
    }

    public synchronized void setComplete(boolean complete) {
        if (this._outputTiming && complete) {
            Preconditions.checkState((this._stopWatch != null ? 1 : 0) != 0);
            this._stopWatch.stop();
            this._messageBuffer.append("\r\n");
            this.appendStatusMessage("============== TIMING INFO ==============");
            this.appendStatusMessage(this._stopWatch.toString());
        }
        this._complete = complete;
    }

    @Nullable
    public String getTaskName() {
        return this._taskName;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public String getTaskID() {
        return this._taskID;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("id", (Object)this.getTaskID()).append("name", (Object)this.getTaskName()).append("complete", this.isComplete()).toString();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

