/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustAllSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(TrustAllSSLSocketFactory.class);
    private final SSLSocketFactory _factory;

    private TrustAllSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
            this._factory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Failed to create SocketFactory", (Throwable)e);
            throw new ApplicationException(e);
        }
    }

    public static SSLSocketFactory getDefault() {
        return new TrustAllSSLSocketFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this._factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr2, int j) throws IOException {
        return this._factory.createSocket(inaddr, i, inaddr2, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this._factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this._factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this._factory.createSocket(s, i);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this._factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this._factory.getSupportedCipherSuites();
    }

    public static X509TrustManager getTrustAllTrustManager() {
        return new TrustAllTrustManager();
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) {
            if (logger.isTraceEnabled()) {
                logger.trace("checkClientTrusted: {}", (Object)Arrays.toString(x509Certificates));
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) {
            if (logger.isTraceEnabled()) {
                logger.trace("checkServerTrusted: {}", (Object)Arrays.toString(x509Certificates));
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

