/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jetbrains.annotations.Nullable;

public final class VersionUtils {
    private static final Pattern MAJOR_MINOR_BUILD_VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)*");

    @Nullable
    public static Version fromString(String versionString) {
        Matcher matcher = MAJOR_MINOR_BUILD_VERSION.matcher(versionString);
        if (matcher.find()) {
            try {
                return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final class Version
    implements Comparable {
        private final int major;
        private final int minor;
        private final int build;

        public Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        public int compareTo(Object compare) {
            Version other = (Version)compare;
            int res = this.major - other.major;
            if (res != 0) {
                return res;
            }
            res = this.minor - other.minor;
            if (res != 0) {
                return res;
            }
            return this.build - other.build;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Version) {
                Version other = (Version)object;
                if (this.major == other.major && this.minor == other.minor && this.build == other.build) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.build);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("major", this.major).append("minor", this.minor).append("build", this.build).toString();
        }
    }
}

