/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import javax.annotation.Tainted;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureObjectInputStream
extends ValidatingObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(SecureObjectInputStream.class);

    public SecureObjectInputStream(@Tainted InputStream input, long depth, long maxBytes, String ... acceptedPackages) throws IOException {
        super(input);
        this.accept(acceptedPackages);
        this.setObjectInputFilter(filterInfo -> {
            if (depth >= 0L && filterInfo.depth() > depth || maxBytes >= 0L && filterInfo.streamBytes() > maxBytes) {
                logger.error("Deny deserialization: depth={}, bytes={}, class={}", new Object[]{filterInfo.depth(), filterInfo.streamBytes(), filterInfo.serialClass()});
                return ObjectInputFilter.Status.REJECTED;
            }
            return ObjectInputFilter.Status.UNDECIDED;
        });
    }
}

