/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.swing.BrowserLinkLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DialogBannerPanel
extends JPanel {
    private final JLabel _bannerDescLabel;
    private final JLabel _bannerTitleLabel;
    private final BrowserLinkLabel _linkLabel;
    private final JLabel _logoImage;

    public DialogBannerPanel(String title, String description, ImageIcon image) {
        this(title, description, image, false, null, null);
    }

    public DialogBannerPanel(String title, String description) {
        this(title, description, null);
    }

    public DialogBannerPanel(String title, String description, ImageIcon image, boolean showLink, String linkURL, String linkText) {
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.gridx = 1;
        gridBagConstraints22.gridwidth = 2;
        gridBagConstraints22.gridheight = 1;
        gridBagConstraints22.anchor = 17;
        gridBagConstraints22.insets = new Insets(0, 20, 0, 5);
        gridBagConstraints22.gridy = 1;
        this._bannerDescLabel = new JLabel();
        this._bannerDescLabel.setText(description);
        this._bannerDescLabel.setFont(new Font("Dialog", 0, 13));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 0;
        this._bannerTitleLabel = new JLabel();
        this._bannerTitleLabel.setText(title);
        this._bannerTitleLabel.setFont(new Font("Dialog", 1, 12));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 2;
        gridBagConstraints15.fill = 0;
        gridBagConstraints15.anchor = 12;
        gridBagConstraints15.weightx = 0.0;
        gridBagConstraints15.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints15.gridy = 0;
        this._linkLabel = new BrowserLinkLabel();
        this._linkLabel.setText("[link goes here]");
        this._linkLabel.setForeground(Color.gray);
        this._linkLabel.setLinkURL("http://www.papercut.biz");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints14.gridheight = 2;
        gridBagConstraints14.gridy = 0;
        this._logoImage = new JLabel();
        this._logoImage.setText("");
        if (image != null) {
            Image scaledImage = image.getImage().getScaledInstance(48, 48, 4);
            this._logoImage.setIcon(new ImageIcon(scaledImage));
        }
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.add((Component)this._logoImage, gridBagConstraints14);
        this.add((Component)this._linkLabel, gridBagConstraints15);
        this.add((Component)this._bannerTitleLabel, gridBagConstraints21);
        this.add((Component)this._bannerDescLabel, gridBagConstraints22);
        this.setPreferredSize(new Dimension(441, 74));
        if (showLink) {
            this._linkLabel.setText(linkText);
            this._linkLabel.setLinkURL(linkURL);
        } else {
            this.remove(this._linkLabel);
        }
    }

    public void setTitleText(String title) {
        this._bannerTitleLabel.setText(title);
    }

    public void setDescText(String desc) {
        this._bannerDescLabel.setText(desc);
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeAndWait(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            JFrame frame = new JFrame();
            frame.setTitle("Banner Test");
            frame.setDefaultCloseOperation(3);
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BorderLayout());
            DialogBannerPanel panel = new DialogBannerPanel("Authentication", "Your login credentials are required for printer access.", null, false, null, null);
            contentPanel.add((Component)panel, "North");
            contentPanel.add((Component)new JPanel(), "South");
            frame.getContentPane().add(contentPanel);
            frame.setPreferredSize(new Dimension(441, 300));
            frame.pack();
            frame.setVisible(true);
        });
    }
}

