/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.concurrent;

import biz.papercut.pcng.util.concurrent.PriorityCallable;
import biz.papercut.pcng.util.concurrent.PriorityRunnable;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;

public class PriorityExecutor
extends ThreadPoolExecutor {
    public PriorityExecutor(int corePoolSize, int maxPoolSize, @Nullable String threadNamePrefix) {
        this(corePoolSize, maxPoolSize, threadNamePrefix, new PriorityBlockingQueue<Runnable>(11, new PriorityTaskComparator()));
    }

    public PriorityExecutor(int corePoolSize, int maxPoolSize, final @Nullable String threadNamePrefix, PriorityBlockingQueue<Runnable> queue) {
        super(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, queue);
        if (threadNamePrefix != null) {
            this.setThreadFactory(new ThreadFactory(){
                final ThreadGroup group;
                final AtomicInteger threadNumber = new AtomicInteger(1);
                final String namePrefix;
                {
                    SecurityManager s = System.getSecurityManager();
                    this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
                    this.namePrefix = threadNamePrefix;
                }

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
                    if (t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            });
        }
    }

    public PriorityBlockingQueue<Runnable> getQueue() {
        return (PriorityBlockingQueue)super.getQueue();
    }

    public Future<Void> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        PriorityTask<Object> ftask = task instanceof PriorityRunnable ? new PriorityTask<Object>(task, null, ((PriorityRunnable)task).getPriority()) : new PriorityTask<Object>(task, null, 0);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new NotImplementedException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        PriorityTask<T> ftask = task instanceof PriorityCallable ? new PriorityTask<T>(task, ((PriorityCallable)task).getPriority()) : new PriorityTask<T>(task, 0);
        this.execute(ftask);
        return ftask;
    }

    private static class PriorityTaskComparator
    implements Comparator<Runnable> {
        private PriorityTaskComparator() {
        }

        @Override
        public int compare(Runnable left, Runnable right) {
            if (left instanceof PriorityTask && right instanceof PriorityTask) {
                return ((PriorityTask)left).compareTo((PriorityTask)right);
            }
            return 0;
        }
    }

    public static class PriorityTask<V>
    extends FutureTask<V>
    implements Comparable<PriorityTask<V>> {
        private int priority;
        private final long creationTime;

        public PriorityTask(Runnable runnable, @Nullable V result, int priority) {
            super(runnable, result);
            this.priority = priority;
            this.creationTime = System.currentTimeMillis();
        }

        public PriorityTask(Callable<V> callable, int priority) {
            super(callable);
            this.priority = priority;
            this.creationTime = System.currentTimeMillis();
        }

        @Override
        public int compareTo(PriorityTask<V> o) {
            return ComparisonChain.start().compare(o.getPriority(), this.getPriority()).compare(this.getCreationTime(), o.getCreationTime()).result();
        }

        public int getPriority() {
            return this.priority;
        }

        public void updatePriority(int priority) {
            this.priority = priority;
        }

        public long getCreationTime() {
            return this.creationTime;
        }
    }
}

