/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashPane {
    private static final Logger logger = LoggerFactory.getLogger(FlashPane.class);
    private static final Color OVERLAY_BACKGROUND = new Color(0, 0, 0, 153);
    private final JPanel _glassPane;
    private final JPanel _overlay;
    private final Timer _hideTimer;
    private final FlashContent.FlashContentEventHandler _eventHandler;
    private final ArrayBlockingQueue<FlashData> _flashQueue;
    private final Semaphore _displayUntilDismissedMutex;
    private volatile FlashData _currentFlash;

    public FlashPane(RootPaneContainer root) {
        if (root == null) {
            throw new NullPointerException("'root' must not be null");
        }
        Component glassPane = root.getGlassPane();
        if (!(glassPane instanceof JPanel)) {
            throw new RuntimeException("Error setting up flash pane (expected glass pane to be a JPanel)");
        }
        this._glassPane = (JPanel)glassPane;
        this._overlay = new JPanel();
        this._overlay.setBackground(OVERLAY_BACKGROUND);
        this._overlay.setLayout(new GridBagLayout());
        this._glassPane.setFocusable(true);
        this._glassPane.setLayout(new BorderLayout());
        this._glassPane.add(this._overlay);
        this._glassPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                FlashPane.this.dismiss();
                logger.debug("Flash pane dismissed via mouse click.");
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this._glassPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                FlashPane.this.dismiss();
                logger.debug("Flash pane dismissed via a typed key.");
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this._hideTimer = new Timer(0, e -> {
            this.dismiss();
            logger.debug("Flash pane dismissed after timeout.");
        });
        this._eventHandler = new FlashContent.FlashContentEventHandler(){

            @Override
            public void activityOccurred() {
                if (FlashPane.this._hideTimer.getInitialDelay() > 0) {
                    FlashPane.this._hideTimer.restart();
                }
            }

            @Override
            public void dismiss() {
                FlashPane.this.hide(true);
            }

            @Override
            public void hide() {
                FlashPane.this.hide(false);
            }
        };
        this._flashQueue = new ArrayBlockingQueue(5);
        this._displayUntilDismissedMutex = new Semaphore(1);
        Thread consumer = new Thread((Runnable)new FlashQueueConsumer(), "FlashQueueConsumer");
        consumer.setDaemon(true);
        consumer.start();
    }

    public void show(FlashContent content, Integer showDurationMS, ActionListener dismissListener) {
        logger.debug("Displaying the flash pane.");
        if (!this._flashQueue.offer(new FlashData(content, showDurationMS, dismissListener))) {
            logger.debug("Too many flashes waiting to display.  Ignoring.");
        }
    }

    public void show(FlashContent content, Integer showDurationMS) {
        this.show(content, showDurationMS, null);
    }

    public void show(FlashContent content) {
        this.show(content, null, null);
    }

    public synchronized void dismiss() {
        this.hide(true);
    }

    private synchronized void hide(boolean raiseDismissEvent) {
        if (this._currentFlash == null) {
            return;
        }
        logger.debug("Hiding the flash pane.");
        this._hideTimer.stop();
        this._glassPane.setVisible(false);
        this._overlay.removeAll();
        if (raiseDismissEvent && this._currentFlash.dismissListener != null) {
            ActionEvent ae = new ActionEvent(this._glassPane, 1001, "DISMISS");
            this._currentFlash.dismissListener.actionPerformed(ae);
        }
        this._currentFlash = null;
        this._displayUntilDismissedMutex.release();
    }

    private class FlashQueueConsumer
    implements Runnable {
        private FlashQueueConsumer() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        FlashPane.this._displayUntilDismissedMutex.acquire();
                        FlashData flashData = (FlashData)FlashPane.this._flashQueue.take();
                        SwingUtilities.invokeAndWait(() -> {
                            flashData.content.setEventHandler(FlashPane.this._eventHandler);
                            FlashPane.this._overlay.add(flashData.content.getComponent());
                            FlashPane.this._glassPane.setVisible(true);
                            flashData.content.showing();
                            if (flashData.showDurationMS != null && flashData.showDurationMS > 0) {
                                FlashPane.this._hideTimer.setInitialDelay(flashData.showDurationMS);
                                FlashPane.this._hideTimer.restart();
                            }
                        });
                        FlashPane.this._currentFlash = flashData;
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (InvocationTargetException ite) {
                    logger.error(ite.getMessage(), (Throwable)ite);
                    continue;
                }
                break;
            }
        }
    }

    private static class FlashData {
        public final FlashContent content;
        public final Integer showDurationMS;
        public final ActionListener dismissListener;

        public FlashData(FlashContent content, Integer showDurationMS, ActionListener dismissListener) {
            this.content = content;
            this.showDurationMS = showDurationMS;
            this.dismissListener = dismissListener;
        }
    }
}

