/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import at.jta.RegistryErrorException;
import at.jta.Regor;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserEventCallBack;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.utils.LaunchingUtils;
import edu.stanford.ejalbert.launching.windows.WindowsBrowser;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class WindowsBrowserLaunching
implements IBrowserLaunching {
    private static final String CONFIGFILE_WINDOWS = "/edu/stanford/ejalbert/launching/windows/windowsConfig.properties";
    public static final String WINKEY_WINVISTA = "windows.winVista";
    public static final String WINKEY_WIN2000 = "windows.win2000";
    public static final String WINKEY_WIN9X = "windows.win9x";
    public static final String WINKEY_WINNT = "windows.winNT";
    private static final String[] WIN_KEYS = new String[]{"windows.win2000", "windows.win9x", "windows.winNT", "windows.winVista"};
    protected final AbstractLogger logger;
    private Map browserNameAndExeMap = null;
    private List browsersToCheck = new ArrayList();
    private String commandsDefaultBrowser;
    private String commandsTargettedBrowser;
    private final String windowsKey;
    private boolean forceNewWindow = false;
    private boolean useRegistry = false;
    private String programFilesFolderTemplate;
    private String driveLetters;

    public WindowsBrowserLaunching(AbstractLogger logger, String windowsKey) {
        if (windowsKey == null) {
            throw new IllegalArgumentException("windowsKey cannot be null");
        }
        if (Arrays.binarySearch(WIN_KEYS, windowsKey) < 0) {
            throw new IllegalArgumentException(windowsKey + " is invalid");
        }
        this.logger = logger;
        this.windowsKey = windowsKey;
        logger.info(windowsKey);
    }

    private String getArrayAsString(String[] array) {
        return Arrays.asList(array).toString();
    }

    private String getProtocol(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return url.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBrowserMap() {
        Class<WindowsBrowserLaunching> clazz = WindowsBrowserLaunching.class;
        synchronized (WindowsBrowserLaunching.class) {
            if (this.browserNameAndExeMap == null) {
                this.browserNameAndExeMap = new HashMap();
                ArrayList tempBrowsersToCheck = new ArrayList(this.browsersToCheck);
                if (this.useRegistry) {
                    this.browserNameAndExeMap.putAll(this.getAvailableBrowsers(tempBrowsersToCheck));
                }
                if (!tempBrowsersToCheck.isEmpty()) {
                    this.browserNameAndExeMap.putAll(this.processFilePathsForBrowsers(tempBrowsersToCheck));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.browserNameAndExeMap;
        }
    }

    private File getProgramFilesPath() {
        File progFilesPath = null;
        if (this.driveLetters != null && this.programFilesFolderTemplate != null) {
            String[] drives = this.driveLetters.split(";");
            for (int idx = 0; idx < drives.length && progFilesPath == null; ++idx) {
                String path = MessageFormat.format(this.programFilesFolderTemplate, drives[idx]);
                File pfPath = new File(path);
                this.logger.debug(path);
                this.logger.debug(pfPath.getPath());
                if (!pfPath.exists()) continue;
                progFilesPath = pfPath;
            }
        }
        return progFilesPath;
    }

    private Map processFilePathsForBrowsers(List tmpBrowsersToCheck) {
        this.logger.debug("finding available browsers in program files path");
        this.logger.debug("browsers to check: " + tmpBrowsersToCheck);
        HashMap<String, WindowsBrowser> browsersAvailable = new HashMap<String, WindowsBrowser>();
        File progFilesPath = this.getProgramFilesPath();
        if (progFilesPath != null) {
            this.logger.debug("program files path: " + progFilesPath.getPath());
            File[] subDirs = progFilesPath.listFiles(new DirFileFilter());
            int subDirsCnt = subDirs != null ? subDirs.length : 0;
            Iterator iter = tmpBrowsersToCheck.iterator();
            HashMap<String, WindowsBrowser> dirNameToBrowser = new HashMap<String, WindowsBrowser>();
            while (iter.hasNext()) {
                WindowsBrowser wBrowser = (WindowsBrowser)iter.next();
                dirNameToBrowser.put(wBrowser.getSubDirName(), wBrowser);
            }
            for (int idx = 0; idx < subDirsCnt && !tmpBrowsersToCheck.isEmpty(); ++idx) {
                WindowsBrowser wBrowser;
                String exeName;
                File fullPathToExe;
                if (!dirNameToBrowser.containsKey(subDirs[idx].getName()) || (fullPathToExe = this.findExeFilePath(subDirs[idx], exeName = (wBrowser = (WindowsBrowser)dirNameToBrowser.get(subDirs[idx].getName())).getBrowserApplicationName() + ".exe")) == null) continue;
                this.logger.debug("Adding browser " + wBrowser.getBrowserDisplayName() + " to available list.");
                wBrowser.setPathToExe(fullPathToExe.getPath());
                this.logger.debug(wBrowser.getPathToExe());
                browsersAvailable.put(wBrowser.getBrowserDisplayName(), wBrowser);
                browsersAvailable.put(wBrowser.getBrowserApplicationName(), wBrowser);
                tmpBrowsersToCheck.remove(wBrowser);
            }
        }
        return browsersAvailable;
    }

    private File findExeFilePath(File path, String exeName) {
        File[] subDirs;
        File exePath = null;
        File[] exeFiles = path.listFiles(new ExeFileNameFilter());
        if (exeFiles != null && exeFiles.length > 0) {
            for (int idx = 0; idx < exeFiles.length && exePath == null; ++idx) {
                if (!exeFiles[idx].getName().equalsIgnoreCase(exeName)) continue;
                exePath = exeFiles[idx].getParentFile();
            }
        }
        if (exePath == null && (subDirs = path.listFiles(new DirFileFilter())) != null && subDirs.length > 0) {
            for (int idx = 0; idx < subDirs.length && exePath == null; ++idx) {
                exePath = this.findExeFilePath(subDirs[idx], exeName);
            }
        }
        return exePath;
    }

    private Map getExeNamesToBrowsers(List tempBrowsersToCheck) {
        HashMap<String, WindowsBrowser> exeNamesToBrowsers = new HashMap<String, WindowsBrowser>();
        for (WindowsBrowser winBrowser : tempBrowsersToCheck) {
            String exeName = winBrowser.getBrowserApplicationName().toLowerCase() + ".exe";
            exeNamesToBrowsers.put(exeName, winBrowser);
        }
        return exeNamesToBrowsers;
    }

    private WindowsBrowser getBrowserFromRegistryEntry(Regor regor, int key, String subKey, String exeKey, Map exesToBrowserObjs) throws RegistryErrorException {
        WindowsBrowser winBrowser = null;
        int key2 = regor.openKey(key, subKey);
        List values = regor.listValueNames(key2);
        for (int x = 0; values != null && x < values.size() && winBrowser == null; ++x) {
            byte[] buf = regor.readValue(key2, (String)values.get(x));
            String path = buf != null ? Regor.parseValue(buf) : "";
            String lpath = path.toLowerCase();
            if (!lpath.endsWith(exeKey)) continue;
            winBrowser = (WindowsBrowser)exesToBrowserObjs.get(exeKey);
            StringTokenizer tokenizer = new StringTokenizer(path, "\\", false);
            StringBuffer pathBuf = new StringBuffer();
            int tokCnt = tokenizer.countTokens();
            for (int idx = 1; idx < tokCnt; ++idx) {
                pathBuf.append(tokenizer.nextToken());
                pathBuf.append('\\');
            }
            winBrowser.setPathToExe(pathBuf.toString());
        }
        return winBrowser;
    }

    private Map getAvailableBrowsers(List tempBrowsersToCheck) {
        this.logger.debug("finding available browsers using registry");
        this.logger.debug("browsers to check: " + tempBrowsersToCheck);
        TreeMap<String, WindowsBrowser> browsersAvailable = new TreeMap<String, WindowsBrowser>(String.CASE_INSENSITIVE_ORDER);
        try {
            Map exesToBrowserObjs = this.getExeNamesToBrowsers(tempBrowsersToCheck);
            Regor regor = new Regor();
            String subKeyName = "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths";
            int key = regor.openKey(-2147483646, subKeyName);
            if (key > -1) {
                List keys = regor.listKeys(key);
                Collections.sort(keys, String.CASE_INSENSITIVE_ORDER);
                for (String exeKey : exesToBrowserObjs.keySet()) {
                    WindowsBrowser winBrowser;
                    int index = Collections.binarySearch(keys, exeKey, String.CASE_INSENSITIVE_ORDER);
                    if (index < 0 || (winBrowser = this.getBrowserFromRegistryEntry(regor, key, (String)keys.get(index), exeKey, exesToBrowserObjs)) == null) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Adding browser " + winBrowser.getBrowserDisplayName() + " to available list.");
                        this.logger.debug(winBrowser.getPathToExe());
                    }
                    browsersAvailable.put(winBrowser.getBrowserDisplayName(), winBrowser);
                    browsersAvailable.put(winBrowser.getBrowserApplicationName(), winBrowser);
                    tempBrowsersToCheck.remove(winBrowser);
                }
            }
        }
        catch (RegistryErrorException ex) {
            this.logger.error("problem accessing registry", ex);
        }
        return browsersAvailable;
    }

    private String[] getCommandArgs(String protocol, String urlString) {
        String commandArgs = LaunchingUtils.replaceArgs(this.commandsDefaultBrowser, null, urlString);
        return commandArgs.split("[ ]");
    }

    private String getCommandArgs(String protocol, WindowsBrowser winbrowser, String urlString, boolean forceNewWindow) {
        int pathLoc;
        String commandArgs = LaunchingUtils.replaceArgs(this.commandsTargettedBrowser, winbrowser.getBrowserApplicationName(), urlString);
        String args = "";
        if (forceNewWindow) {
            args = winbrowser.getForceNewWindowArgs();
        }
        if ((pathLoc = (commandArgs = commandArgs.replaceAll("<args>", args)).indexOf("<path>")) > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(commandArgs.substring(0, pathLoc));
            buf.append(winbrowser.getPathToExe());
            buf.append(commandArgs.substring(pathLoc + 6));
            commandArgs = buf.toString();
        }
        return commandArgs;
    }

    private boolean openUrlWithBrowser(WindowsBrowser winBrowser, String protocol, String urlString) throws BrowserLaunchingExecutionException {
        boolean success = false;
        try {
            this.logger.info(winBrowser.getBrowserDisplayName());
            this.logger.info(urlString);
            this.logger.info(protocol);
            String args = this.getCommandArgs(protocol, winBrowser, urlString, this.forceNewWindow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(args);
            }
            Process process = Runtime.getRuntime().exec(args);
            process.waitFor();
            int exitValue = process.exitValue();
            success = exitValue == 0 || exitValue == 1;
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
        return success;
    }

    public void setBrowserEventCallBack(IBrowserEventCallBack callback) {
    }

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            URL configUrl = this.getClass().getResource(CONFIGFILE_WINDOWS);
            if (configUrl == null) {
                throw new BrowserLaunchingInitializingException("unable to find config file: /edu/stanford/ejalbert/launching/windows/windowsConfig.properties");
            }
            Properties configProps = new Properties();
            configProps.load(configUrl.openStream());
            String sepChar = configProps.getProperty("delimchar");
            for (String string : configProps.keySet()) {
                if (!string.startsWith("browser.")) continue;
                WindowsBrowser winBrowser = new WindowsBrowser(sepChar, configProps.getProperty(string));
                this.browsersToCheck.add(winBrowser);
            }
            String string = configProps.getProperty(this.windowsKey, null);
            if (string == null) {
                throw new BrowserLaunchingInitializingException(this.windowsKey + " is not a valid property");
            }
            String[] winConfigItems = string.split(sepChar);
            this.commandsDefaultBrowser = winConfigItems[0];
            this.commandsTargettedBrowser = winConfigItems[1];
            Boolean boolVal = new Boolean(winConfigItems[2]);
            this.useRegistry = boolVal;
            String propValue = System.getProperty("win.browser.disc.policy", null);
            if ("disk".equals(propValue)) {
                this.useRegistry = false;
            } else if ("registry".equals(propValue)) {
                this.useRegistry = true;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Browser discovery policy property value=" + (propValue == null ? "null" : propValue));
                this.logger.debug("useRegistry=" + Boolean.toString(this.useRegistry));
            }
            this.programFilesFolderTemplate = configProps.getProperty("program.files.template", null);
            this.driveLetters = configProps.getProperty("drive.letters", null);
            this.browsersToCheck = Collections.unmodifiableList(this.browsersToCheck);
        }
        catch (IOException ioex) {
            throw new BrowserLaunchingInitializingException(ioex);
        }
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            Map browserMap;
            WindowsBrowser winBrowser;
            this.logger.info(urlString);
            String protocol = this.getProtocol(urlString);
            this.logger.info(protocol);
            boolean successfullSystemPropLaunch = false;
            String browserName = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            if (browserName != null && (winBrowser = (WindowsBrowser)(browserMap = this.getBrowserMap()).get(browserName)) != null) {
                this.logger.debug("using browser from system property");
                successfullSystemPropLaunch = this.openUrlWithBrowser(winBrowser, protocol, urlString);
            }
            if (!successfullSystemPropLaunch) {
                String[] args = this.getCommandArgs(protocol, urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getArrayAsString(args));
                }
                Process process = Runtime.getRuntime().exec(args);
                process.waitFor();
                process.exitValue();
            }
        }
        catch (Exception e) {
            this.logger.error("fatal exception", e);
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if ("Default".equals(browser) || browser == null) {
            this.logger.info("default or null browser target; falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            Map browserMap = this.getBrowserMap();
            WindowsBrowser winBrowser = (WindowsBrowser)browserMap.get(browser);
            if (winBrowser == null) {
                this.logger.info("the available browsers list does not contain: " + browser);
                this.logger.info("falling through to non-targetted openUrl");
                this.openUrl(urlString);
            } else {
                String protocol = null;
                try {
                    protocol = this.getProtocol(urlString);
                }
                catch (MalformedURLException malrulex) {
                    throw new BrowserLaunchingExecutionException(malrulex);
                }
                boolean successfullLaunch = this.openUrlWithBrowser(winBrowser, protocol, urlString);
                if (!successfullLaunch) {
                    this.logger.debug("falling through to non-targetted openUrl");
                    this.openUrl(urlString);
                }
            }
        }
    }

    public void openUrl(List browsers, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if (browsers == null || browsers.isEmpty()) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            String protocol = null;
            try {
                protocol = this.getProtocol(urlString);
            }
            catch (MalformedURLException malrulex) {
                throw new BrowserLaunchingExecutionException(malrulex);
            }
            Map browserMap = this.getBrowserMap();
            boolean success = false;
            Iterator iter = browsers.iterator();
            while (iter.hasNext() && !success) {
                WindowsBrowser winBrowser = (WindowsBrowser)browserMap.get(iter.next());
                if (winBrowser == null) continue;
                success = this.openUrlWithBrowser(winBrowser, protocol, urlString);
            }
            if (!success) {
                this.logger.debug("none of listed browsers succeeded; falling through to non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    public List getBrowserList() {
        Map browserMap = this.getBrowserMap();
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add("Default");
        for (String key : browserMap.keySet()) {
            WindowsBrowser winBrowser;
            if (!key.equals((winBrowser = (WindowsBrowser)browserMap.get(key)).getBrowserDisplayName())) continue;
            browsers.add(winBrowser.getBrowserDisplayName());
        }
        return browsers;
    }

    public boolean getNewWindowPolicy() {
        return this.forceNewWindow;
    }

    public void setNewWindowPolicy(boolean forceNewWindow) {
        this.forceNewWindow = forceNewWindow;
    }

    static {
        Arrays.sort(WIN_KEYS);
    }

    private static final class ExeFileNameFilter
    implements FilenameFilter {
        private ExeFileNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".exe");
        }
    }

    private static final class DirFileFilter
    implements FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

