/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObjectPool<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleObjectPool.class);
    protected final ConcurrentMap<K, V> _map;
    protected final Function<K, V> _computeNewValue;

    public SimpleObjectPool(Function<K, V> computeNewValue, long expireDuration, TimeUnit unit) {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(expireDuration, unit).removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> notification) {
                if (logger.isDebugEnabled() && notification.wasEvicted()) {
                    logger.debug("Expiring instance: " + notification.getKey() + ", size: " + SimpleObjectPool.this._map.size());
                }
            }
        }).build();
        this._map = cache.asMap();
        this._computeNewValue = computeNewValue;
    }

    public PoolRef acquire(K key) {
        Preconditions.checkNotNull(key, (Object)"Key cannot be null");
        Object r = this._map.remove(key);
        if (r != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Got pooled instance for: " + key + ", size: " + this._map.size());
            }
            return new PoolRef(key, r);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("New instance for: " + key + ", size: " + this._map.size());
        }
        r = this._computeNewValue.apply(key);
        return new PoolRef(key, r);
    }

    protected void release(PoolRef ref, boolean returnToPool) {
        Preconditions.checkNotNull((Object)ref, (Object)"Cannot release null pool reference");
        if (ref.isValid()) {
            if (returnToPool) {
                this._map.put(ref._key, ref._value);
            } else {
                this._map.remove(ref._key);
            }
            ref.invalidate();
            if (logger.isDebugEnabled()) {
                logger.debug((returnToPool ? "Returned" : "Discarded") + " instance for: " + ref._key + ", size: " + this._map.size());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Instance has already been released from the pool for: " + ref._key + ", size: " + this._map.size());
        }
    }

    public final class PoolRef {
        private final K _key;
        @CheckForNull
        private volatile V _value;

        private PoolRef(K k, V v) {
            Preconditions.checkNotNull(k, (Object)"key is null");
            Preconditions.checkNotNull(v, (Object)"value is null");
            this._key = k;
            this._value = v;
        }

        public K getKey() {
            return this._key;
        }

        @CheckForNull
        public V getValue() {
            Preconditions.checkState((boolean)this.isValid(), (Object)"Trying to access released pool object");
            return this._value;
        }

        public boolean isValid() {
            return this._value != null;
        }

        private void invalidate() {
            this._value = null;
        }

        public void release() {
            SimpleObjectPool.this.release(this, true);
        }

        public void discard() {
            SimpleObjectPool.this.release(this, false);
        }

        public String toString() {
            return this._key + "=" + (this._value == null ? "(released)" : this._value);
        }
    }
}

