/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class VerboseProcess
implements Closeable {
    private static final String UTF_8 = "UTF-8";
    private static final int N_MONITORS = 2;
    private final transient Process process;
    private final transient Level olevel;
    private final transient Level elevel;
    private final transient Thread[] monitors;
    private transient boolean closed;

    public VerboseProcess(Process prc) {
        this(prc, Level.INFO, Level.WARNING);
    }

    public VerboseProcess(ProcessBuilder builder) {
        this(VerboseProcess.start(builder));
    }

    public VerboseProcess(Process prc, Level stdout, Level stderr) {
        if (prc == null) {
            throw new IllegalArgumentException("process can't be NULL");
        }
        if (stdout == null) {
            throw new IllegalArgumentException("stdout LEVEL can't be NULL");
        }
        if (stderr == null) {
            throw new IllegalArgumentException("stderr LEVEL can't be NULL");
        }
        if (Level.ALL.equals(stdout)) {
            throw new IllegalArgumentException("stdout LEVEL can't be set to ALL because it is intended only for internal configuration");
        }
        if (Level.ALL.equals(stderr)) {
            throw new IllegalArgumentException("stderr LEVEL can't be set to ALL because it is intended only for internal configuration");
        }
        this.process = prc;
        this.olevel = stdout;
        this.elevel = stderr;
        this.monitors = new Thread[2];
    }

    public VerboseProcess(ProcessBuilder bdr, Level stdout, Level stderr) {
        this(VerboseProcess.start(bdr), stdout, stderr);
    }

    public String stdout() {
        return this.stdout(true);
    }

    public String stdoutQuietly() {
        return this.stdout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result waitFor() throws InterruptedException {
        CountDownLatch done = new CountDownLatch(2);
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        this.launchMonitors(done, stdout, stderr);
        int code = 0;
        try {
            code = this.process.waitFor();
        }
        catch (Throwable throwable) {
            Logger.debug(this, "#waitFor(): process finished: %s", this.process);
            if (!done.await(2L, TimeUnit.SECONDS)) {
                Logger.error(this, "#wait() failed");
            }
            throw throwable;
        }
        Logger.debug(this, "#waitFor(): process finished: %s", this.process);
        if (!done.await(2L, TimeUnit.SECONDS)) {
            Logger.error(this, "#wait() failed");
        }
        try {
            return new Result(code, stdout.toString(UTF_8), stderr.toString(UTF_8));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Thread[] threadArray = this.monitors;
        synchronized (this.monitors) {
            this.closed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Thread monitor : this.monitors) {
                if (monitor == null) continue;
                monitor.interrupt();
                Logger.debug(this, "monitor interrupted");
            }
            this.process.destroy();
            Logger.debug(this, "underlying process destroyed");
            return;
        }
    }

    private static Process start(ProcessBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder can't be NULL");
        }
        try {
            Process process = builder.start();
            process.getOutputStream().close();
            return process;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String stdout(boolean check) {
        Result result;
        long start = System.currentTimeMillis();
        try {
            result = this.waitFor();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        Logger.debug(this, "#stdout(): process %s completed (code=%d, size=%d) in %[ms]s", this.process, result.code(), result.stdout().length(), System.currentTimeMillis() - start);
        if (check && result.code() != 0) {
            throw new IllegalArgumentException(Logger.format("Non-zero exit code %d: %[text]s", result.code(), result.stdout()));
        }
        return result.stdout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchMonitors(CountDownLatch done, ByteArrayOutputStream stdout, ByteArrayOutputStream stderr) {
        Thread[] threadArray = this.monitors;
        synchronized (this.monitors) {
            if (this.closed) {
                done.countDown();
                done.countDown();
            } else {
                this.monitors[0] = this.monitor(this.process.getInputStream(), done, stdout, this.olevel, "out");
                Logger.debug(this, "#waitFor(): waiting for stdout of %s in %s...", this.process, this.monitors[0]);
                this.monitors[1] = this.monitor(this.process.getErrorStream(), done, stderr, this.elevel, "err");
                Logger.debug(this, "#waitFor(): waiting for stderr of %s in %s...", this.process, this.monitors[1]);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private Thread monitor(InputStream input, CountDownLatch done, OutputStream output, Level level, String name) {
        Thread thread = new Thread(new VerboseRunnable(new Monitor(input, done, output, level), false));
        thread.setName(String.format("VrbPrc.Monitor-%d-%s", this.hashCode(), name));
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static void close(Closeable res) {
        try {
            res.close();
        }
        catch (IOException ex) {
            Logger.error(VerboseProcess.class, "failed to close resource: %[exception]s", ex);
        }
    }

    public String toString() {
        return "VerboseProcess(process=" + this.process + ", olevel=" + this.olevel + ", elevel=" + this.elevel + ", monitors=" + Arrays.deepToString(this.monitors) + ", closed=" + this.closed + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerboseProcess)) {
            return false;
        }
        VerboseProcess other = (VerboseProcess)o;
        Process this$process = this.process;
        Process other$process = other.process;
        return !(this$process == null ? other$process != null : !this$process.equals(other$process));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Process $process = this.process;
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        return result;
    }

    public static final class Result {
        private final transient int exit;
        private final transient String out;
        private final transient String err;

        Result(int code, String stdout, String stderr) {
            this.exit = code;
            this.out = stdout;
            this.err = stderr;
        }

        public int code() {
            return this.exit;
        }

        public String stdout() {
            return this.out;
        }

        public String stderr() {
            return this.err;
        }
    }

    private static final class Monitor
    implements Callable<Void> {
        private final transient InputStream input;
        private final transient CountDownLatch done;
        private final transient OutputStream output;
        private final transient Level level;

        Monitor(InputStream inp, CountDownLatch latch, OutputStream out, Level lvl) {
            this.input = inp;
            this.done = latch;
            this.output = out;
            this.level = lvl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BufferedReader reader = new BufferedReader(Channels.newReader(Channels.newChannel(this.input), VerboseProcess.UTF_8));
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.output, VerboseProcess.UTF_8));
                try {
                    while (true) {
                        if (Thread.interrupted()) {
                            Logger.debug(VerboseProcess.class, "explicitly interrupting read from buffer");
                            break;
                        }
                        String line = reader.readLine();
                        if (line == null) {
                            break;
                        }
                        Logger.log(this.level, VerboseProcess.class, ">> %s", line);
                        writer.write(line);
                        writer.newLine();
                    }
                }
                catch (ClosedByInterruptException ex) {
                    Thread.interrupted();
                    Logger.debug(VerboseProcess.class, "Monitor is interrupted in the expected way");
                }
                catch (IOException ex) {
                    Logger.error(VerboseProcess.class, "Error reading from process stream: %[exception]s", ex);
                }
                finally {
                    VerboseProcess.close(writer);
                    this.done.countDown();
                }
            }
            finally {
                VerboseProcess.close(reader);
            }
            return null;
        }
    }
}

