/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IPAddressChecker {
    private static final Logger logger = LoggerFactory.getLogger(IPAddressChecker.class);
    public static final String ALL_PRIVATE_IP_RANGES = "ALL_PRIVATE_IP_RANGES";

    private IPAddressChecker() {
    }

    public static boolean isAddressMatchInSet(String testAddress, String[] matchAddresses) {
        return IPAddressChecker.isAddressMatchInSet(testAddress, Arrays.asList(matchAddresses));
    }

    public static boolean isAddressMatchInSet(String testAddress, Iterable<String> matchAddresses) {
        for (String matchAddress : matchAddresses) {
            if (!IPAddressChecker.isAddressInRange(matchAddress, testAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAddressInRange(String range, String address) {
        if (ALL_PRIVATE_IP_RANGES.equals(range)) {
            return IPAddressChecker.isPrivateAddress(address);
        }
        range = StringUtils.trimToEmpty((String)range);
        address = StringUtils.trimToEmpty((String)address);
        int slashPos = range.indexOf(47);
        if (slashPos < 0) {
            return range.equals(address);
        }
        String network = range.substring(0, slashPos);
        String mask = range.substring(slashPos + 1);
        try {
            byte[] netBytes = InetAddress.getByName(network).getAddress();
            byte[] maskBytes = InetAddress.getByName(mask).getAddress();
            byte[] addrBytes = InetAddress.getByName(address).getAddress();
            for (int i = 0; i < netBytes.length; ++i) {
                if ((netBytes[i] & maskBytes[i]) == (addrBytes[i] & maskBytes[i])) continue;
                return false;
            }
        }
        catch (UnknownHostException e) {
            logger.error("Error testing IP address range: " + range + " address: " + address, (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isAnyAddress(String address) {
        return StringUtils.isBlank((String)address) || address.equals("*");
    }

    public static boolean isPrivateAddress(String address) {
        try {
            byte[] ipBytes;
            InetAddress ip = InetAddress.getByName(address);
            if (ip.isLoopbackAddress() || ip.isSiteLocalAddress() || ip.isLinkLocalAddress()) {
                return true;
            }
            if (ip instanceof Inet6Address && (ipBytes = ip.getAddress()).length == 16 && (ipBytes[0] & 0xFF) == 253) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.error("Error testing whether address is private: " + address, (Throwable)e);
            return false;
        }
        return false;
    }
}

