/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AccountDisabledTester;
import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.PrintJobDetailsPanel;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClient;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import biz.papercut.pcng.util.swing.BrowserLinkLabel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.DisabledComboBox;
import biz.papercut.pcng.util.swing.DisabledComboBoxItemTester;
import biz.papercut.pcng.util.swing.SwingWorker;
import com.google.common.base.Stopwatch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAccountDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(SelectAccountDialog.class);
    protected static final String MFA_AUTH_ERROR_ENROLL = "AADSTS50079";
    protected static final String MFA_AUTH_ERROR_DEVICE = "AADSTS50076";
    private JPanel _contentPanel;
    private JPanel _buttonPanel;
    private JButton _okButton;
    private JButton _cancelButton;
    private JPanel _mainPanel;
    private JPanel _printOptionPanel;
    private JPanel _otherUserAccountPanel;
    private JRadioButton _anotherUserAccountOption;
    private PrintJobDetailsPanel _printDetailPanel;
    private final ButtonGroup _accountOptionGroup;
    private ServerConnection _serverConnection;
    private ClientPrintJob _printJob;
    private JRadioButton _userAccountOption;
    private JPanel _accountWithPinPanel;
    private JRadioButton _accountWithPinOption;
    private JLabel _accountPinLabel;
    private JPasswordField _accountPinTextField;
    private JLabel _otherUserLabel;
    private JTextField _otherUserTextField;
    private JLabel _otherPasswordLabel;
    private JPasswordField _otherPasswordTextField;
    private final UserClientConfig _userClientConfig;
    private final ClientPrintPopupConfig _printJobConfig;
    private JPanel _titleBanner;
    private JLabel _logoImage;
    private BrowserLinkLabel _linkLabel;
    private JLabel _bannerTitleLabel;
    private JLabel _bannerDescLabel;
    private JPanel _accountListPanel;
    private JRadioButton _accountListOption;
    private JLabel _accountListLabel;
    private JComboBox<Object> _accountListCombo;
    private JCheckBox _applyToAllInQueue;
    private volatile int _jobsInQueue = 1;
    private boolean _selectionAppliedToAllJobs;
    private final Timer _updateJobInfoTimer = new Timer(1000, e -> this.fetchUpdatedJobInfo());
    private final Timer _updateJobCountTimer = new Timer(2000, e -> this.fetchUpdatedJobCount());

    public SelectAccountDialog(JFrame owner, UserClientConfig clientConfig, ServerConnection connection, ClientPrintJob job, ClientPrintPopupConfig printJobConfig) {
        super((Frame)owner, true);
        URL customIcon;
        logger.debug("Loading account dialog");
        this.setAlwaysOnTop(true);
        this.toFront();
        this.setPrintJob(job);
        this.setServerConnection(connection);
        this.initialize();
        this.localiseForm();
        this.setLocationRelativeTo(null);
        this._accountOptionGroup = new ButtonGroup();
        this._accountOptionGroup.add(this.getUserAccountOption());
        this._accountOptionGroup.add(this.getAccountListOption());
        this._accountOptionGroup.add(this.getAccountWithPinOption());
        this._accountOptionGroup.add(this.getAnotherUserAccountOption());
        this.getRootPane().setDefaultButton(this.getOkButton());
        this._userClientConfig = clientConfig;
        this._printJobConfig = printJobConfig;
        this.getUserAccountOption().setSelected(true);
        if (this._printJobConfig.onlyAllowChargingToPersonalAccount()) {
            this.getMainPanel().remove(this.getPrintOptionPanel());
            this._bannerDescLabel.setText(SelectAccountDialog.getMessage("confirm-print", new String[0]));
        } else {
            if (!this._printJobConfig.isCanChargeToPersonalAccount()) {
                this.getPrintOptionPanel().remove(this.getUserAccountOption());
                if (this.getUserAccountOption().isSelected()) {
                    this.getAccountListOption().setSelected(true);
                }
            }
            if (!this._printJobConfig.isCanChargeToAccountFromList()) {
                this.getPrintOptionPanel().remove(this.getAccountListPanel());
                if (this.getAccountListOption().isSelected()) {
                    this.getAccountWithPinOption().setSelected(true);
                }
            }
            if (!this._printJobConfig.isCanChargeToAccountWithPin()) {
                this.getPrintOptionPanel().remove(this.getAccountWithPinPanel());
                if (this.getAccountWithPinOption().isSelected()) {
                    this.getAnotherUserAccountOption().setSelected(true);
                }
            }
            if (!this._printJobConfig.isCanChargeToOtherUser()) {
                this.getPrintOptionPanel().remove(this.getOtherUserAccountPanel());
            }
            if ((this._printJobConfig.isCanChargeToAccountWithPin() || this._printJobConfig.isCanChargeToAccountFromList()) && !this._printJobConfig.isChargeSharedAccountWhenSelected()) {
                this._accountListOption.setText(SelectAccountDialog.getMessage("account-from-list-allocate", new String[0]));
                this._accountWithPinOption.setText(SelectAccountDialog.getMessage("account-with-pin-allocate", new String[0]));
            }
        }
        if (clientConfig.getServerGlobalConfig().isPinVisible()) {
            this._accountPinTextField.setEchoChar('\u0000');
        }
        if (clientConfig.getServerGlobalConfig().isShowLink()) {
            this._linkLabel.setText(clientConfig.getServerGlobalConfig().getLinkText());
            this._linkLabel.setLinkURL(clientConfig.getServerGlobalConfig().getLinkURL());
        } else {
            this.getTitleBanner().remove((Component)this._linkLabel);
        }
        if (!clientConfig.getServerGlobalConfig().isShowDocumentCost()) {
            this.getPrintDetailPanel().setCost("");
        }
        if ((customIcon = UserClientUtils.getCustomIconImage()) != null) {
            try {
                ImageIcon orig = new ImageIcon(customIcon);
                Image scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
                this._logoImage.setIcon(new ImageIcon(scaledImage));
            }
            catch (Exception e2) {
                logger.debug("Unable to load custom icon: " + e2.getMessage());
            }
        }
        this.doLayout();
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SelectAccountDialog.this.setSize(new Dimension(Math.max(minWidth, SelectAccountDialog.this.getWidth()), Math.max(minHeight, SelectAccountDialog.this.getHeight())));
            }
        });
        this.setSize((int)((double)minWidth * 1.2), minHeight);
        if (job.isPreNotification()) {
            this._updateJobInfoTimer.start();
        }
        this._printDetailPanel.displayJobDetails(job);
        this.loadAccountList(job, clientConfig.getDisplayUserName());
        this.selectBestPrintOption(clientConfig);
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this, !this._userClientConfig.isDisableToastNotifications());
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    protected SelectAccountDialog(UserClientConfig config, ClientPrintPopupConfig printJobConfig) {
        this._accountOptionGroup = new ButtonGroup();
        this._userClientConfig = config;
        this._printJobConfig = printJobConfig;
        this._userAccountOption = new JRadioButton();
        this._userAccountOption.setSelected(false);
        this._accountWithPinOption = new JRadioButton();
        this._accountWithPinOption.setSelected(false);
        this._accountListOption = new JRadioButton();
        this._accountListOption.setSelected(false);
        this._anotherUserAccountOption = new JRadioButton();
        this._anotherUserAccountOption.setSelected(true);
        this._otherUserTextField = new JTextField();
        this._otherUserTextField.setText("otherUser@microsoftonline.com");
        this._otherPasswordTextField = new JPasswordField();
        this._otherPasswordTextField.setText("password");
        this._accountListCombo = new JComboBox();
    }

    private void localiseForm() {
        this.setTitle(SelectAccountDialog.getMessage("title", new String[0]));
        this._bannerTitleLabel.setText(SelectAccountDialog.getMessage("title", new String[0]));
        this._bannerDescLabel.setText(SelectAccountDialog.getMessage("description", new String[0]));
        ((TitledBorder)this._printOptionPanel.getBorder()).setTitle(SelectAccountDialog.getMessage("print-job-actions", new String[0]));
        this._userAccountOption.setText(SelectAccountDialog.getMessage("personal-account", new String[0]));
        this._accountListOption.setText(SelectAccountDialog.getMessage("account-from-list", new String[0]));
        this._accountListLabel.setText(SelectAccountDialog.getMessage("account-list", new String[0]));
        this._accountWithPinOption.setText(SelectAccountDialog.getMessage("account-with-pin", new String[0]));
        this._accountPinLabel.setText(SelectAccountDialog.getMessage("account-pin", new String[0]));
        this._anotherUserAccountOption.setText(SelectAccountDialog.getMessage("other-user-account", new String[0]));
        this._otherUserLabel.setText(SelectAccountDialog.getMessage("username", new String[0]));
        this._otherPasswordLabel.setText(SelectAccountDialog.getMessage("password", new String[0]));
        this._applyToAllInQueue.setText(SelectAccountDialog.getMessage("apply-to-all-in-queue", "1"));
        this._updateJobCountTimer.start();
        this._okButton.setText(SelectAccountDialog.getMessage("print", new String[0]));
        this._cancelButton.setText(SelectAccountDialog.getMessage("cancel", new String[0]));
    }

    private void loadAccountList(final ClientPrintJob job, final String username) {
        this._accountListCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{SelectAccountDialog.getMessage("fetching-accounts", new String[0])}));
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ClientAccount> _accounts;
            private final Stopwatch loadTimer = Stopwatch.createUnstarted();

            public Object construct() {
                this.loadTimer.start();
                this._accounts = ClientAccountCache.getInstance().getUserAccounts(job, username, SelectAccountDialog.this);
                return null;
            }

            public void finished() {
                logger.debug("Accounts: " + this._accounts.size());
                if (this._accounts.size() > 0) {
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this._accounts.toArray());
                    model.insertElementAt(SelectAccountDialog.getMessage("select-account", new String[0]), 0);
                    SelectAccountDialog.this._accountListCombo.setModel(model);
                    if (this._accounts.size() == 1) {
                        logger.debug("One account, pre-select it.");
                        SelectAccountDialog.this._accountListCombo.setSelectedIndex(1);
                    } else {
                        SelectAccountDialog.this._accountListCombo.setSelectedIndex(0);
                        String defaultSelectedAccount = SelectAccountDialog.this._userClientConfig.getDefaultSelectedAccount();
                        if (StringUtils.isNotBlank((String)defaultSelectedAccount)) {
                            for (ClientAccount account : this._accounts) {
                                if (!account.getDisplayName().equalsIgnoreCase(defaultSelectedAccount)) continue;
                                logger.debug("Found default shared account and pre-selecting: " + defaultSelectedAccount);
                                SelectAccountDialog.this._accountListCombo.setSelectedItem(account);
                            }
                        } else {
                            ClientPopupInfo lastPopupSelection = SelectAccountDialog.this._userClientConfig.getLastPopupSelection();
                            if (lastPopupSelection != null && lastPopupSelection.getChargeToAccountType() == ChargeToAccountType.AccountFromList) {
                                for (ClientAccount account : this._accounts) {
                                    if (account.getAccountId() != lastPopupSelection.getAccountId()) continue;
                                    SelectAccountDialog.this._accountListCombo.setSelectedItem(account);
                                }
                            }
                        }
                    }
                    if (SelectAccountDialog.this.getAccountListOption().isSelected()) {
                        SelectAccountDialog.this.enableOKButtonIfAllowed();
                        SelectAccountDialog.this._accountListCombo.setEnabled(true);
                        if (SelectAccountDialog.this._accountListOption.isSelected()) {
                            SelectAccountDialog.this._accountListCombo.requestFocus();
                        }
                    }
                } else {
                    logger.debug("No account available");
                    SelectAccountDialog.this._accountListCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{SelectAccountDialog.getMessage("no-accounts", new String[0])}));
                }
                logger.debug("Total account load time: " + this.loadTimer);
            }
        };
        worker.start();
    }

    private void initialize() {
        this.setTitle("[title]");
        this.setContentPane(this.getContentPanel());
        this.setSize(422, 474);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectAccountDialog.this.cancelButtonPressed(false);
            }
        });
    }

    private JPanel getContentPanel() {
        if (this._contentPanel == null) {
            this._contentPanel = new JPanel();
            this._contentPanel.setLayout(new BorderLayout());
            this._contentPanel.add((Component)this.getTitleBanner(), "North");
            this._contentPanel.add((Component)this.getButtonPanel(), "South");
            this._contentPanel.add((Component)this.getMainPanel(), "Center");
        }
        return this._contentPanel;
    }

    private JPanel getButtonPanel() {
        if (this._buttonPanel == null) {
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 0;
            gridBagConstraints28.weightx = 1.0;
            gridBagConstraints28.anchor = 17;
            gridBagConstraints28.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints28.gridy = 0;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints27.gridy = 0;
            gridBagConstraints27.gridx = 2;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.insets = new Insets(5, 5, 5, 2);
            gridBagConstraints26.gridy = 0;
            gridBagConstraints26.gridx = 1;
            this._buttonPanel = new JPanel();
            this._buttonPanel.setLayout(new GridBagLayout());
            this._buttonPanel.add((Component)this.getOkButton(), gridBagConstraints26);
            this._buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints27);
            this._buttonPanel.add((Component)this.getApplyToAllInQueue(), gridBagConstraints28);
        }
        return this._buttonPanel;
    }

    private JButton getOkButton() {
        if (this._okButton == null) {
            this._okButton = new JButton();
            this._okButton.setText("[Print]");
            this._okButton.addActionListener(e -> {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.okButtonPressed();
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this._okButton;
    }

    protected void okButtonPressed() {
        logger.debug("Print button pressed");
        this._updateJobInfoTimer.stop();
        ClientPopupInfo popupInfo = new ClientPopupInfo();
        popupInfo.setChargeToAccountType(ChargeToAccountType.PersonalAccount);
        if (this.getAccountWithPinOption().isSelected()) {
            popupInfo.setChargeToAccountType(ChargeToAccountType.AccountWithPin);
            popupInfo.setAccountPin(new String(this.getAccountPinTextField().getPassword()));
        } else if (this.getAccountListOption().isSelected()) {
            popupInfo.setChargeToAccountType(ChargeToAccountType.AccountFromList);
            ClientAccount acct = (ClientAccount)this.getAccountListCombo().getSelectedItem();
            popupInfo.setAccountId(acct.getAccountId());
        } else if (this.getAnotherUserAccountOption().isSelected()) {
            popupInfo.setChargeToAccountType(ChargeToAccountType.OtherUser);
            popupInfo.setUserName(this.getOtherUserTextField().getText());
            popupInfo.setPassword(new String(this.getOtherPasswordTextField().getPassword()));
        }
        boolean applyToAll = this._applyToAllInQueue.isSelected();
        ClientJobUpdateResponse status = applyToAll ? this.getServerConnection().updateAllPendingPrintJobs(this.getPrintJob(), false, popupInfo) : this.getServerConnection().updatePendingPrintJob(this.getPrintJob(), false, popupInfo);
        this._userClientConfig.setLastPopupSelection(popupInfo);
        if (status.isSuccess()) {
            this.closeAccountDialog(applyToAll);
        } else {
            if (StringUtils.isNotBlank((String)status.getErrorMessage()) && (status.getErrorMessage().contains(MFA_AUTH_ERROR_ENROLL) || status.getErrorMessage().contains(MFA_AUTH_ERROR_DEVICE))) {
                this.handleMfa(this.getPrintJob(), applyToAll, popupInfo);
                return;
            }
            DialogUtils.showInformationMessageDialog((Component)this, (String)SelectAccountDialog.getMessage("error", new String[0]), (String)status.getErrorMessage());
            if (!status.isAllowRetry()) {
                this.closeAccountDialog(false);
            }
        }
    }

    protected void handleMfa(ClientPrintJob job, boolean applyToAll, ClientPopupInfo popupInfo) {
        this.setVisible(false);
        String otherUsername = popupInfo.getUserName();
        String extAuthUrl = this.getServerConnection().getExtAuthUrlForPrintAsOtherUser(otherUsername);
        boolean browseSuccess = this.browseExtAuthUrl(extAuthUrl);
        boolean printSuccess = false;
        if (browseSuccess) {
            printSuccess = this.getServerConnection().tryPrintAsAnotherUserViaMfa(job, applyToAll, popupInfo);
            logger.debug("Server response for print as another user: {}", (Object)printSuccess);
        }
        if (!printSuccess) {
            DialogUtils.showInformationMessageDialog((Component)this, (String)SelectAccountDialog.getMessage("error", new String[0]), (String)SelectAccountDialog.getMessage("print-as-other-user-via-mfa-failed", otherUsername));
        }
        this._updateJobCountTimer.stop();
        this._updateJobInfoTimer.stop();
        this._selectionAppliedToAllJobs = applyToAll;
        this._accountListCombo.removeAllItems();
    }

    protected boolean browseExtAuthUrl(String extAuthUrl) {
        logger.debug("Received external auth URL to print as another user: {}", (Object)extAuthUrl);
        boolean success = UserClientUtils.browseUrlInOS(extAuthUrl);
        return success;
    }

    protected void fetchUpdatedJobCount() {
        this._updateJobCountTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                int newJobCount = SelectAccountDialog.this.getServerConnection().getPendingPrintJobCount();
                if (newJobCount != SelectAccountDialog.this._jobsInQueue) {
                    SelectAccountDialog.this._updateJobCountTimer.setDelay(4000);
                    SelectAccountDialog.this._updateJobCountTimer.setInitialDelay(4000);
                    SelectAccountDialog.this._jobsInQueue = newJobCount;
                }
                return null;
            }

            public void finished() {
                SelectAccountDialog.this._applyToAllInQueue.setText(SelectAccountDialog.getMessage("apply-to-all-in-queue", new String[]{String.valueOf(SelectAccountDialog.this._jobsInQueue)}));
                SelectAccountDialog.this._updateJobCountTimer.start();
                int newDelay = Math.min(SelectAccountDialog.this._updateJobCountTimer.getDelay() + 2000, 20000);
                SelectAccountDialog.this._updateJobCountTimer.setDelay(newDelay);
                SelectAccountDialog.this._updateJobCountTimer.setInitialDelay(newDelay);
            }
        };
        worker.start();
    }

    private void fetchUpdatedJobInfo() {
        this._updateJobInfoTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                SelectAccountDialog.this.getServerConnection().getUpdatedPrintJobInfo(SelectAccountDialog.this.getPrintJob());
                return null;
            }

            public void finished() {
                SelectAccountDialog.this._printDetailPanel.displayJobDetails(SelectAccountDialog.this.getPrintJob());
                if (SelectAccountDialog.this.getPrintJob().isPreNotification()) {
                    int newDelay = Math.min(SelectAccountDialog.this._updateJobInfoTimer.getDelay() + 1000, 10000);
                    SelectAccountDialog.this._updateJobInfoTimer.setInitialDelay(newDelay);
                    SelectAccountDialog.this._updateJobInfoTimer.setDelay(newDelay);
                    SelectAccountDialog.this._updateJobInfoTimer.start();
                }
            }
        };
        worker.start();
    }

    protected void cancelButtonPressed(boolean cancelAll) {
        logger.debug("Cancel button pressed");
        this._updateJobInfoTimer.stop();
        this.getServerConnection().cancelPendingPrintJob(this.getPrintJob(), cancelAll);
        this.closeAccountDialog(cancelAll);
    }

    private void closeAccountDialog(boolean processedAllPending) {
        this._updateJobCountTimer.stop();
        this._updateJobInfoTimer.stop();
        this._selectionAppliedToAllJobs = processedAllPending;
        this._accountListCombo.removeAllItems();
        this.setVisible(false);
    }

    public boolean selectionAppliedToAllJobs() {
        return this._selectionAppliedToAllJobs;
    }

    private JButton getCancelButton() {
        if (this._cancelButton == null) {
            this._cancelButton = new JButton();
            this._cancelButton.setText("[Cancel]");
            this._cancelButton.addActionListener(e -> {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.cancelButtonPressed(this._applyToAllInQueue.isSelected());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this._cancelButton;
    }

    private JPanel getMainPanel() {
        if (this._mainPanel == null) {
            this._mainPanel = new JPanel();
            this._mainPanel.setLayout(new BorderLayout());
            this._mainPanel.add((Component)this.getPrintDetailPanel(), "North");
            this._mainPanel.add((Component)this.getPrintOptionPanel(), "Center");
        }
        return this._mainPanel;
    }

    private JPanel getPrintOptionPanel() {
        if (this._printOptionPanel == null) {
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridy = 1;
            gridBagConstraints110.weightx = 1.0;
            gridBagConstraints110.fill = 2;
            gridBagConstraints110.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints110.anchor = 10;
            gridBagConstraints110.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.anchor = 11;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 3;
            TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "[Select the account to charge]", 0, 0, null, null);
            this._printOptionPanel = new JPanel();
            this._printOptionPanel.setLayout(new GridBagLayout());
            this._printOptionPanel.setBorder(titledBorder);
            this._printOptionPanel.add((Component)this.getOtherUserAccountPanel(), gridBagConstraints11);
            this._printOptionPanel.add((Component)this.getUserAccountOption(), gridBagConstraints);
            this._printOptionPanel.add((Component)this.getAccountListPanel(), gridBagConstraints110);
            this._printOptionPanel.add((Component)this.getAccountWithPinPanel(), gridBagConstraints1);
        }
        return this._printOptionPanel;
    }

    private JPanel getOtherUserAccountPanel() {
        if (this._otherUserAccountPanel == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridy = 2;
            gridBagConstraints20.weightx = 0.85;
            gridBagConstraints20.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints20.gridx = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 13;
            gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints17.weightx = 0.0;
            gridBagConstraints17.gridy = 2;
            this._otherPasswordLabel = new JLabel();
            this._otherPasswordLabel.setText("[Password]");
            this._otherPasswordLabel.setHorizontalAlignment(4);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 0.1;
            gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridy = 1;
            this._otherUserLabel = new JLabel();
            this._otherUserLabel.setText("[Username]");
            this._otherUserLabel.setPreferredSize(new Dimension(75, 16));
            this._otherUserLabel.setHorizontalAlignment(4);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.weighty = 0.5;
            gridBagConstraints2.gridx = 0;
            this._otherUserAccountPanel = new JPanel();
            this._otherUserAccountPanel.setLayout(new GridBagLayout());
            this._otherUserAccountPanel.add((Component)this.getAnotherUserAccountOption(), gridBagConstraints2);
            this._otherUserAccountPanel.add((Component)this._otherUserLabel, gridBagConstraints3);
            this._otherUserAccountPanel.add((Component)this.getOtherUserTextField(), gridBagConstraints4);
            this._otherUserAccountPanel.add((Component)this._otherPasswordLabel, gridBagConstraints17);
            this._otherUserAccountPanel.add((Component)this.getOtherPasswordTextField(), gridBagConstraints20);
        }
        return this._otherUserAccountPanel;
    }

    private JRadioButton getAnotherUserAccountOption() {
        if (this._anotherUserAccountOption == null) {
            this._anotherUserAccountOption = new JRadioButton();
            this._anotherUserAccountOption.setText("[Charge to another users account]");
            this._anotherUserAccountOption.addItemListener(e -> {
                boolean enabled;
                boolean bl = enabled = e.getStateChange() == 1;
                if (enabled) {
                    logger.debug("Select other user option");
                    this.enableOKButtonIfAllowed();
                }
                this._otherUserTextField.setEnabled(enabled);
                this._otherPasswordTextField.setEnabled(enabled);
                if (enabled) {
                    this._otherUserTextField.requestFocus();
                }
            });
        }
        return this._anotherUserAccountOption;
    }

    private PrintJobDetailsPanel getPrintDetailPanel() {
        if (this._printDetailPanel == null) {
            this._printDetailPanel = new PrintJobDetailsPanel();
        }
        return this._printDetailPanel;
    }

    public ServerConnection getServerConnection() {
        return this._serverConnection;
    }

    public void setServerConnection(ServerConnection serverConnection) {
        this._serverConnection = serverConnection;
    }

    public synchronized ClientPrintJob getPrintJob() {
        return this._printJob;
    }

    public synchronized void setPrintJob(ClientPrintJob printJob) {
        this._printJob = printJob;
    }

    private JRadioButton getUserAccountOption() {
        if (this._userAccountOption == null) {
            this._userAccountOption = new JRadioButton();
            this._userAccountOption.setText("[Charge to my personal user account]");
            this._userAccountOption.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    logger.debug("Select personal account option");
                    this.enableOKButtonIfAllowed();
                }
            });
        }
        return this._userAccountOption;
    }

    protected void enableOKButtonIfAllowed() {
        boolean enabled = true;
        if (this.getUserAccountOption().isSelected()) {
            enabled = true;
        } else if (this.getAccountWithPinOption().isSelected()) {
            enabled = this.getAccountPinTextField().getPassword().length > 0;
        } else if (this.getAccountListOption().isSelected()) {
            enabled = this.getAccountListCombo().getSelectedIndex() > 0;
        } else if (this.getAnotherUserAccountOption().isSelected()) {
            boolean bl = enabled = StringUtils.isNotBlank((String)this.getOtherUserTextField().getText()) && this.getOtherPasswordTextField().getPassword().length > 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Print button enabled: " + enabled);
        }
        this.getOkButton().setEnabled(enabled);
    }

    private JPanel getAccountWithPinPanel() {
        if (this._accountWithPinPanel == null) {
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridy = 2;
            gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.gridx = 1;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints18.anchor = 13;
            gridBagConstraints18.weightx = 0.1;
            gridBagConstraints18.gridy = 2;
            this._accountPinLabel = new JLabel();
            this._accountPinLabel.setText("[Account pin]");
            this._accountPinLabel.setPreferredSize(new Dimension(75, 16));
            this._accountPinLabel.setHorizontalAlignment(4);
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridy = 1;
            gridBagConstraints16.fill = 0;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.gridwidth = 2;
            gridBagConstraints16.gridx = 0;
            this._accountWithPinPanel = new JPanel();
            this._accountWithPinPanel.setLayout(new GridBagLayout());
            this._accountWithPinPanel.add((Component)this.getAccountWithPinOption(), gridBagConstraints16);
            this._accountWithPinPanel.add((Component)this._accountPinLabel, gridBagConstraints18);
            this._accountWithPinPanel.add((Component)this.getAccountPinTextField(), gridBagConstraints19);
        }
        return this._accountWithPinPanel;
    }

    private JRadioButton getAccountWithPinOption() {
        if (this._accountWithPinOption == null) {
            this._accountWithPinOption = new JRadioButton();
            this._accountWithPinOption.setText("[Charge to account with pin]");
            this._accountWithPinOption.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    logger.debug("Select account with PIN option");
                    this.enableOKButtonIfAllowed();
                    this._accountPinTextField.setEnabled(true);
                    this._accountPinTextField.requestFocus();
                } else {
                    this._accountPinTextField.setEnabled(false);
                }
            });
        }
        return this._accountWithPinOption;
    }

    private JPasswordField getAccountPinTextField() {
        if (this._accountPinTextField == null) {
            this._accountPinTextField = new JPasswordField();
            this._accountPinTextField.setEnabled(false);
            this._accountPinTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }
            });
        }
        return this._accountPinTextField;
    }

    private JTextField getOtherUserTextField() {
        if (this._otherUserTextField == null) {
            this._otherUserTextField = new JTextField();
            this._otherUserTextField.setEnabled(false);
            this._otherUserTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }
            });
        }
        return this._otherUserTextField;
    }

    private JPasswordField getOtherPasswordTextField() {
        if (this._otherPasswordTextField == null) {
            this._otherPasswordTextField = new JPasswordField();
            this._otherPasswordTextField.setEnabled(false);
            this._otherPasswordTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectAccountDialog.this.enableOKButtonIfAllowed();
                }
            });
        }
        return this._otherPasswordTextField;
    }

    private static String getMessage(String key, String ... args) {
        String fullKey = "SelectAccount." + key;
        return Messages.getString(UserClient.class, fullKey, args);
    }

    private JPanel getTitleBanner() {
        if (this._titleBanner == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridwidth = 2;
            gridBagConstraints22.gridheight = 1;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(0, 20, 0, 5);
            gridBagConstraints22.gridy = 1;
            this._bannerDescLabel = new JLabel();
            this._bannerDescLabel.setText("[description]");
            this._bannerDescLabel.setFont(new Font("Dialog", 0, 13));
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(10, 10, 0, 0);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.gridy = 0;
            this._bannerTitleLabel = new JLabel();
            this._bannerTitleLabel.setText("[title]");
            this._bannerTitleLabel.setFont(new Font("Dialog", 1, 12));
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 2;
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.anchor = 12;
            gridBagConstraints15.weightx = 0.0;
            gridBagConstraints15.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints15.gridy = 0;
            this._linkLabel = new BrowserLinkLabel();
            this._linkLabel.setText("[link goes here]");
            this._linkLabel.setForeground(Color.gray);
            this._linkLabel.setLinkURL("http://www.papercut.biz");
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.insets = new Insets(5, 5, 5, 0);
            gridBagConstraints14.gridheight = 2;
            gridBagConstraints14.gridy = 0;
            this._logoImage = new JLabel();
            this._logoImage.setText("");
            ImageIcon orig = new ImageIcon(this.getClass().getResource("images/client-icon.png"));
            Image scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
            this._logoImage.setIcon(new ImageIcon(scaledImage));
            this._titleBanner = new JPanel();
            this._titleBanner.setLayout(new GridBagLayout());
            this._titleBanner.setBackground(Color.white);
            this._titleBanner.add((Component)this._logoImage, gridBagConstraints14);
            this._titleBanner.add((Component)this._linkLabel, gridBagConstraints15);
            this._titleBanner.add((Component)this._bannerTitleLabel, gridBagConstraints21);
            this._titleBanner.add((Component)this._bannerDescLabel, gridBagConstraints22);
        }
        return this._titleBanner;
    }

    private JPanel getAccountListPanel() {
        if (this._accountListPanel == null) {
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 2;
            gridBagConstraints25.gridy = 1;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints25.gridx = 1;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.anchor = 13;
            gridBagConstraints23.weightx = 0.1;
            gridBagConstraints23.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints23.gridy = 1;
            this._accountListLabel = new JLabel();
            this._accountListLabel.setText("[Account List]");
            this._accountListLabel.setPreferredSize(new Dimension(75, 16));
            this._accountListLabel.setHorizontalAlignment(4);
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.fill = 0;
            gridBagConstraints24.weightx = 0.0;
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints24.gridwidth = 2;
            gridBagConstraints24.gridy = 0;
            this._accountListPanel = new JPanel();
            this._accountListPanel.setLayout(new GridBagLayout());
            this._accountListPanel.add((Component)this.getAccountListOption(), gridBagConstraints24);
            this._accountListPanel.add((Component)this._accountListLabel, gridBagConstraints23);
            this._accountListPanel.add((Component)this.getAccountListCombo(), gridBagConstraints25);
        }
        return this._accountListPanel;
    }

    private JRadioButton getAccountListOption() {
        if (this._accountListOption == null) {
            this._accountListOption = new JRadioButton();
            this._accountListOption.setText("[Charge to account selected from list]");
            this._accountListOption.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    logger.debug("Select account list option");
                    this._accountListCombo.setEnabled(true);
                    this._accountListCombo.requestFocus();
                    if (this._accountListCombo.getItemCount() > 1) {
                        this.enableOKButtonIfAllowed();
                    }
                } else {
                    this._accountListCombo.setEnabled(false);
                }
            });
        }
        return this._accountListOption;
    }

    private JComboBox getAccountListCombo() {
        if (this._accountListCombo == null) {
            this._accountListCombo = new DisabledComboBox((DisabledComboBoxItemTester)new AccountDisabledTester());
            this._accountListCombo.setEnabled(false);
            this._accountListCombo.setPreferredSize(new Dimension(11, 22));
            this._accountListCombo.addActionListener(e -> this.enableOKButtonIfAllowed());
        }
        return this._accountListCombo;
    }

    private JCheckBox getApplyToAllInQueue() {
        if (this._applyToAllInQueue == null) {
            this._applyToAllInQueue = new JCheckBox();
            this._applyToAllInQueue.setText("[apply to all documents in queue (Jobs: ?)]");
        }
        return this._applyToAllInQueue;
    }

    protected void setApplyToAllInQueue(boolean value) {
        this.getApplyToAllInQueue().setSelected(value);
    }

    private void selectBestPrintOption(UserClientConfig clientConfig) {
        this.getPrintOptionPanel().requestFocus();
        ChargeToAccountType defaultSelectedOption = clientConfig.getDefaultSelectedOption();
        if (defaultSelectedOption != null) {
            switch (defaultSelectedOption) {
                case PersonalAccount: {
                    if (!this.getMainPanel().isAncestorOf(this.getUserAccountOption())) break;
                    this.getUserAccountOption().doClick();
                    break;
                }
                case AccountFromList: {
                    if (!this.getMainPanel().isAncestorOf(this.getAccountListOption())) break;
                    this.getAccountListOption().doClick();
                    break;
                }
                case AccountWithPin: {
                    if (!this.getMainPanel().isAncestorOf(this.getAccountWithPinOption())) break;
                    this.getAccountWithPinOption().doClick();
                    break;
                }
                case OtherUser: {
                    if (!this.getMainPanel().isAncestorOf(this.getAnotherUserAccountOption())) break;
                    this.getAnotherUserAccountOption().doClick();
                    break;
                }
            }
        } else if (StringUtils.isNotBlank((String)clientConfig.getServerUserConfig().getDefaultSharedAccountName())) {
            if (this.getMainPanel().isAncestorOf(this.getAccountListOption())) {
                this.getAccountListOption().doClick();
            }
        } else {
            ClientPopupInfo lastPopupSelection = clientConfig.getLastPopupSelection();
            if (lastPopupSelection != null) {
                switch (lastPopupSelection.getChargeToAccountType()) {
                    case PersonalAccount: {
                        if (!this.getMainPanel().isAncestorOf(this.getUserAccountOption())) break;
                        this.getUserAccountOption().doClick();
                        break;
                    }
                    case AccountFromList: {
                        if (!this.getMainPanel().isAncestorOf(this.getAccountListOption())) break;
                        this.getAccountListOption().doClick();
                        break;
                    }
                    case AccountWithPin: {
                        if (!this.getMainPanel().isAncestorOf(this.getAccountWithPinOption())) break;
                        this.getAccountWithPinOption().doClick();
                        this._accountPinTextField.setText(lastPopupSelection.getAccountPin());
                        break;
                    }
                    case OtherUser: {
                        if (!this.getMainPanel().isAncestorOf(this.getAnotherUserAccountOption())) break;
                        this.getAnotherUserAccountOption().doClick();
                        this._otherUserTextField.setText(lastPopupSelection.getUserName());
                        break;
                    }
                }
            }
        }
        if (clientConfig.getDefaultSelectedAccountPin() != null) {
            this._accountPinTextField.setText(clientConfig.getDefaultSelectedAccountPin());
        }
        if (this.getPrintOptionPanel().getComponentCount() == 1) {
            if (this.getAccountWithPinOption().isSelected()) {
                this.getAccountPinTextField().requestFocus();
            } else if (this.getAnotherUserAccountOption().isSelected()) {
                this.getOtherUserTextField().requestFocus();
            }
        }
    }
}

