/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferredListTableModel
extends AbstractTableModel {
    private static final Logger logger = LoggerFactory.getLogger(PreferredListTableModel.class);
    private AccountIdListModel _preferredAccountIds;
    private List<ClientAccount> _preferredAccountsList;

    PreferredListTableModel() {
        ClientAccount ca = new ClientAccount(1L);
        ca.setDisabled(true);
        ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
        this._preferredAccountsList = new ArrayList<ClientAccount>(1);
        this._preferredAccountsList.add(ca);
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccountIds) {
        this._preferredAccountIds = preferredAccountIds;
        this.buildList(accounts);
        this._preferredAccountIds.addChangeListener(e -> {
            this.buildList(accounts);
            this.fireTableDataChanged();
        });
        this.fireTableDataChanged();
    }

    public void dispose() {
        this._preferredAccountsList.clear();
    }

    private void buildList(List<ClientAccount> accounts) {
        this._preferredAccountsList = new ArrayList<ClientAccount>(this._preferredAccountIds.size());
        for (int i = 0; i < this._preferredAccountIds.size(); ++i) {
            Long id = this._preferredAccountIds.get(i);
            Optional<ClientAccount> account = accounts.stream().filter(a -> a.getAccountId() == id.longValue() && !a.isDisabled()).findFirst();
            if (account.isPresent()) {
                this._preferredAccountsList.add(account.get());
                continue;
            }
            logger.error("Failed locate active account for preferred id {}", (Object)id);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
        }
        if (column == 1) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
        }
        throw new IllegalArgumentException("Unexpected column index");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this._preferredAccountsList == null) {
            return 1;
        }
        return this._preferredAccountsList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (this._preferredAccountsList == null) {
                return Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]);
            }
            ClientAccount a = this._preferredAccountsList.get(rowIndex);
            if (a != null) {
                return a;
            }
            return "--error--";
        }
        if (columnIndex == 1) {
            ClientAccount a = this._preferredAccountsList.get(rowIndex);
            if (a != null) {
                return a.getFullPin();
            }
            return "";
        }
        throw new IllegalArgumentException("unexpected column index");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }
}

