/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.ObjectUtils;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPrintPopupConfig {
    private static final Logger logger = LoggerFactory.getLogger(ClientPrintPopupConfig.class);
    private boolean _canChargeToPersonalAccount = true;
    private boolean _canChargeToAccountWithPin;
    private boolean _canChargeToAccountFromList;
    private boolean _canChargeToOtherUser;
    private PopupType _popupType = PopupType.Confirmation;
    private boolean _chargeSharedAccountWhenSelected = true;
    private boolean _userMustSelectChargeRate;
    private static final String PREFIX = "print.conf.";
    private static final String FIELD_CAN_CHARGE_TO_PERSONAL = "print.conf.can-charge-to-personal";
    private static final String FIELD_CAN_CHARGE_TO_ACCT_FROM_LIST = "print.conf.can-charge-to-account-from-list";
    private static final String FIELD_CAN_CHARGE_TO_ACCT_WITH_PIN = "print.conf.can-charge-to-account-with-pin";
    private static final String FIELD_CAN_CHARGE_TO_OTHER_USER = "print.conf.can-charge-to-other-user";
    private static final String FIELD_CHARGE_SHARED_ACCT_WHEN_SELECTED = "print.conf.charge-shared-acct-when-selected";
    private static final String FIELD_CHARGE_RATE_MUST_SELECT = "print.conf.must-select-charge-rate";
    private static final String FIELD_USE_ADVANCED_POPUP = "print.conf.use-advanced-popup";
    private static final String FIELD_POPUP_TYPE = "print.conf.popup-type";

    public ClientPrintPopupConfig() {
    }

    public ClientPrintPopupConfig(Hashtable<String, Object> data) {
        Boolean boolVal = (Boolean)data.get(FIELD_CAN_CHARGE_TO_ACCT_WITH_PIN);
        if (boolVal != null) {
            this.setCanChargeToAccountWithPin(boolVal);
        }
        if ((boolVal = (Boolean)data.get(FIELD_CAN_CHARGE_TO_ACCT_FROM_LIST)) != null) {
            this.setCanChargeToAccountFromList(boolVal);
        }
        if ((boolVal = (Boolean)data.get(FIELD_CAN_CHARGE_TO_OTHER_USER)) != null) {
            this.setCanChargeToOtherUser(boolVal);
        }
        if ((boolVal = (Boolean)data.get(FIELD_CAN_CHARGE_TO_PERSONAL)) != null) {
            this.setCanChargeToPersonalAccount(boolVal);
        }
        if ((boolVal = (Boolean)data.get(FIELD_CHARGE_SHARED_ACCT_WHEN_SELECTED)) != null) {
            this.setChargeSharedAccountWhenSelected(boolVal);
        }
        if ((boolVal = (Boolean)data.get(FIELD_CHARGE_RATE_MUST_SELECT)) != null) {
            this.setUserMustSelectChargeRate(boolVal);
        }
        String strVal = (String)data.get(FIELD_POPUP_TYPE);
        try {
            this.setPopupType(PopupType.valueOf(strVal));
        }
        catch (Exception e) {
            logger.error("Unknown popup type: " + strVal + ". Assume standard popup.");
            this.setPopupType(PopupType.Standard);
        }
    }

    public Hashtable<String, Object> convertToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put(FIELD_CAN_CHARGE_TO_PERSONAL, this.isCanChargeToPersonalAccount());
        data.put(FIELD_CAN_CHARGE_TO_ACCT_FROM_LIST, this.isCanChargeToAccountFromList());
        data.put(FIELD_CAN_CHARGE_TO_ACCT_WITH_PIN, this.isCanChargeToAccountWithPin());
        data.put(FIELD_CAN_CHARGE_TO_OTHER_USER, this.isCanChargeToOtherUser());
        data.put(FIELD_CHARGE_SHARED_ACCT_WHEN_SELECTED, this.isChargeSharedAccountWhenSelected());
        data.put(FIELD_POPUP_TYPE, this.getPopupType().name());
        data.put(FIELD_USE_ADVANCED_POPUP, this.isUseAdvancedPopup());
        data.put(FIELD_CHARGE_RATE_MUST_SELECT, this.isUserMustSelectChargeRate());
        return data;
    }

    public boolean onlyAllowChargingToPersonalAccount() {
        if (this.isCanChargeToAccountWithPin()) {
            return false;
        }
        if (this.isCanChargeToAccountFromList()) {
            return false;
        }
        return !this.isCanChargeToOtherUser();
    }

    public boolean isCanChargeToAccountWithPin() {
        return this._canChargeToAccountWithPin;
    }

    public void setCanChargeToAccountWithPin(boolean canChargeToAccountWithPin) {
        this._canChargeToAccountWithPin = canChargeToAccountWithPin;
    }

    public boolean isCanChargeToOtherUser() {
        return this._canChargeToOtherUser;
    }

    public void setCanChargeToOtherUser(boolean canChargeToOtherUser) {
        this._canChargeToOtherUser = canChargeToOtherUser;
    }

    public boolean isCanChargeToPersonalAccount() {
        return this._canChargeToPersonalAccount;
    }

    public void setCanChargeToPersonalAccount(boolean canChargeToPersonalAccount) {
        this._canChargeToPersonalAccount = canChargeToPersonalAccount;
    }

    public boolean isCanChargeToAccountFromList() {
        return this._canChargeToAccountFromList;
    }

    public void setCanChargeToAccountFromList(boolean canChargeToAccountFromList) {
        this._canChargeToAccountFromList = canChargeToAccountFromList;
    }

    public boolean isChargeSharedAccountWhenSelected() {
        return this._chargeSharedAccountWhenSelected;
    }

    public void setChargeSharedAccountWhenSelected(boolean chargeSharedAccountWhenSelected) {
        this._chargeSharedAccountWhenSelected = chargeSharedAccountWhenSelected;
    }

    public synchronized PopupType getPopupType() {
        return this._popupType;
    }

    public synchronized void setPopupType(PopupType popupType) {
        this._popupType = popupType;
    }

    public boolean isUseAdvancedPopup() {
        return this._popupType == PopupType.Advanced;
    }

    public synchronized boolean isUserMustSelectChargeRate() {
        return this._userMustSelectChargeRate;
    }

    public synchronized void setUserMustSelectChargeRate(boolean userMustSelectChargeRate) {
        this._userMustSelectChargeRate = userMustSelectChargeRate;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("popupType", (Object)this._popupType).append("canChargePersonal", this._canChargeToPersonalAccount).append("canChargeAccountFromList", this._canChargeToAccountFromList).append("canChargeAccountWithPin", this._canChargeToAccountWithPin).append("canChargeToOtherUser", this._canChargeToOtherUser).append("chargeSharedAccountWhenSelected", this._chargeSharedAccountWhenSelected).append("userMustSelectChargeRate", this._userMustSelectChargeRate).toString();
    }

    public static enum PopupType {
        Confirmation,
        Standard,
        Advanced,
        Manager;

    }
}

