/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameAlias {
    private static final Logger logger = LoggerFactory.getLogger(NameAlias.class);
    private static final int CHECK_FOR_CHANGES_PERIOD_MS = 10000;
    @Nullable
    private Map<String, String> _cachedMapping;
    private long _lastModifiedTime = -1L;
    private long _lastCheckTime = -1L;
    private final File _mappingFile;
    private final boolean _caseSensitive;

    public NameAlias(File mappingFile, boolean caseSensitive) {
        this._mappingFile = mappingFile;
        this._caseSensitive = caseSensitive;
        this.loadMappingDataIfRequired();
    }

    private void loadMappingDataIfRequired() {
        if (this._lastCheckTime + 10000L > System.currentTimeMillis()) {
            return;
        }
        this._lastCheckTime = System.currentTimeMillis();
        if (!this._mappingFile.exists()) {
            this._cachedMapping = null;
            return;
        }
        long lastModified = this._mappingFile.lastModified();
        if (lastModified <= this._lastModifiedTime) {
            return;
        }
        logger.debug("Mapping file modified, so need to reload.");
        try (FileInputStream fstream = new FileInputStream(this._mappingFile);
             BufferedReader br = new BufferedReader(new InputStreamReader(fstream));){
            String strLine;
            this._cachedMapping = new HashMap<String, String>();
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#") || StringUtils.isBlank((String)strLine)) continue;
                String[] temp = strLine.split("\t|=|:");
                if (temp.length >= 2) {
                    String alias = StringUtils.trimToNull((String)temp[0]);
                    String name = StringUtils.trimToNull((String)temp[1]);
                    if (alias == null || name == null) continue;
                    if (!this._caseSensitive) {
                        alias = alias.toLowerCase();
                    }
                    this._cachedMapping.put(alias, name);
                    continue;
                }
                logger.warn("Bad data in alias file: " + strLine);
            }
            this._lastModifiedTime = lastModified;
        }
        catch (Exception e) {
            logger.error("Strange IO error raised when trying to load name aliases file: " + this._mappingFile.getAbsolutePath(), (Throwable)e);
        }
    }

    @Nullable
    public synchronized String lookupNameByAlias(@Nullable String alias) {
        this.loadMappingDataIfRequired();
        if (this._cachedMapping == null) {
            return null;
        }
        if (StringUtils.isBlank((String)alias)) {
            return null;
        }
        if (!this._caseSensitive) {
            return this._cachedMapping.get(alias.toLowerCase());
        }
        return this._cachedMapping.get(alias);
    }
}

