/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccountListTableModel
extends AbstractTableModel {
    private static final Logger logger = LoggerFactory.getLogger(AccountListTableModel.class);
    private List<ClientAccount> _allAccounts;
    private List<ClientAccount> _displayedAccounts;
    private final List<ClientAccount> _filteredAccounts = new ArrayList<ClientAccount>();
    private AccountIdListModel _preferredAccounts;

    public AccountListTableModel() {
        ClientAccount ca = new ClientAccount(1L);
        ca.setDisabled(true);
        ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
        this._displayedAccounts = new ArrayList<ClientAccount>(1);
        this._displayedAccounts.add(ca);
        this._preferredAccounts = new AccountIdListModel("");
    }

    public void dispose() {
        this._allAccounts = new ArrayList<ClientAccount>();
        this._displayedAccounts = this._allAccounts;
        this._filteredAccounts.clear();
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccounts, String initialFilter) {
        this._allAccounts = accounts;
        this.sortAccounts(this._allAccounts);
        String currentParent = "";
        ArrayList<ClientAccount> placeHolderParents = new ArrayList<ClientAccount>();
        for (ClientAccount ca : this._allAccounts) {
            if (ca.isParent()) {
                currentParent = ca.getParentName();
                continue;
            }
            if (ca.getParentName().equals(currentParent)) continue;
            ClientAccount placeHolder = new ClientAccount(-9999L);
            placeHolder.setDisabled(true);
            placeHolder.setParentName(ca.getParentName());
            placeHolder.setSubName("");
            placeHolderParents.add(placeHolder);
            currentParent = ca.getParentName();
        }
        if (placeHolderParents.size() > 0) {
            logger.debug("Added {} place holder parent account. Resorting.", (Object)placeHolderParents.size());
            this._allAccounts.addAll(placeHolderParents);
            this.sortAccounts(this._allAccounts);
        }
        this._preferredAccounts = preferredAccounts;
        this.buildFilteredAccounts(initialFilter);
        this.fireTableDataChanged();
    }

    private void sortAccounts(List<ClientAccount> accounts) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Collections.sort(accounts, (c1, c2) -> {
            if (c1.getAccountId() == -1L) {
                return -1;
            }
            if (c2.getAccountId() == -1L) {
                return 1;
            }
            int r = c1.getParentName().compareToIgnoreCase(c2.getParentName());
            if (r == 0) {
                r = c1.getSubName().compareToIgnoreCase(c2.getSubName());
            }
            return r;
        });
        logger.debug("Sorting {} accounts took {} ms", (Object)accounts.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
        }
        if (column == 1) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
        }
        if (column == 2) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_PREFERRED", (String[])new String[0]);
        }
        throw new IllegalArgumentException("Unexpected column index");
    }

    public void applyFilter(String filter) {
        this.buildFilteredAccounts(filter);
        this.fireTableDataChanged();
    }

    private void buildFilteredAccounts(String filter) {
        if (this._allAccounts == null) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Filter: {}", (Object)filter);
        ClientAccount currentParent = null;
        boolean currentParentMatched = true;
        String filterLC = StringUtils.trimToEmpty((String)filter).toLowerCase();
        this._filteredAccounts.clear();
        if (StringUtils.isEmpty((String)filterLC)) {
            this._displayedAccounts = this._allAccounts;
        } else {
            for (ClientAccount ca : this._allAccounts) {
                if (ca.isParent()) {
                    currentParent = ca;
                    if (this.accountMatchesFilter(ca, filterLC)) {
                        this._filteredAccounts.add(ca);
                        currentParentMatched = true;
                        continue;
                    }
                    currentParentMatched = false;
                    continue;
                }
                if (currentParentMatched) {
                    this._filteredAccounts.add(ca);
                    continue;
                }
                if (!this.accountMatchesFilter(ca, filterLC)) continue;
                if (currentParent != null) {
                    this._filteredAccounts.add(currentParent);
                    currentParent = null;
                }
                this._filteredAccounts.add(ca);
            }
            this._displayedAccounts = this._filteredAccounts;
        }
        logger.debug("Filter '{}' took: {} ms", (Object)filter, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean accountMatchesFilter(ClientAccount ca, String filter) {
        return ca.getParentName().toLowerCase().contains(filter) || ca.getSubName().toLowerCase().contains(filter) || ca.getFullPin().toLowerCase().contains(filter);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this._displayedAccounts == null) {
            return 1;
        }
        return this._displayedAccounts.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (this._displayedAccounts == null) {
                return Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]);
            }
            return this._displayedAccounts.get(rowIndex);
        }
        if (columnIndex == 1) {
            if (this._displayedAccounts == null) {
                return "";
            }
            ClientAccount ca = this._displayedAccounts.get(rowIndex);
            return ca.getFullPin();
        }
        if (columnIndex == 2) {
            if (this._displayedAccounts == null) {
                return false;
            }
            Long accountID = this._displayedAccounts.get(rowIndex).getAccountId();
            return this._preferredAccounts.contains(accountID);
        }
        throw new IllegalArgumentException("unexpected column index");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this._displayedAccounts == null) {
            return;
        }
        if (col == 2) {
            Long accountID = this._displayedAccounts.get(row).getAccountId();
            if (((Boolean)value).booleanValue()) {
                if (!this._preferredAccounts.contains(accountID)) {
                    this._preferredAccounts.add(accountID);
                }
            } else if (this._preferredAccounts.contains(accountID)) {
                this._preferredAccounts.remove(accountID);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2 && !this._displayedAccounts.get(row).isDisabled();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }
}

