/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.release;

import biz.papercut.pcng.common.release.ReleasePrinterStatus;
import biz.papercut.pcng.common.release.ReleaseStatusCode;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobReleaseStatus {
    private static final Logger logger = LoggerFactory.getLogger(JobReleaseStatus.class);
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_PRINTER_IDS = "printerIds";
    private static final String FIELD_PRINTER_STATUS = "printerStatus";
    private ReleaseStatusCode _status = ReleaseStatusCode.Success;
    @Nullable
    private ReleaseStatusErrorInfo errorInfo;

    public JobReleaseStatus() {
    }

    public JobReleaseStatus(Hashtable<String, Object> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        this.dataToReleaseStatus(data);
        if (this._status.equals((Object)ReleaseStatusCode.QueueInError)) {
            this.dataToErrorInfo(data);
        }
    }

    private void dataToReleaseStatus(Hashtable<String, Object> data) {
        String valueStr = (String)data.get(FIELD_STATUS);
        if (StringUtils.isNotBlank((String)valueStr)) {
            ReleaseStatusCode code = null;
            try {
                code = ReleaseStatusCode.valueOf(valueStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (code == null) {
                logger.warn("Unknown job release status code: {}. Assume success.", (Object)valueStr);
                this.setStatus(ReleaseStatusCode.Success);
            } else {
                this.setStatus(code);
            }
        }
    }

    private void dataToErrorInfo(Hashtable<String, Object> data) {
        String statusStr = (String)data.get(FIELD_PRINTER_STATUS);
        Vector idsVector = (Vector)data.get(FIELD_PRINTER_IDS);
        if (StringUtils.isNotBlank((String)statusStr)) {
            ReleasePrinterStatus printerStatus;
            try {
                printerStatus = ReleasePrinterStatus.valueOf(statusStr);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Unknown Printer Status: {}. Default to UNKNOWN.", (Object)statusStr);
                printerStatus = ReleasePrinterStatus.UNKNOWN;
            }
            HashSet printerIds = new HashSet();
            if (idsVector != null) {
                printerIds = idsVector.stream().map(Long::parseLong).collect(Collectors.toCollection(HashSet::new));
            }
            this.setErrorInfo(new ReleaseStatusErrorInfo(printerIds, printerStatus));
        }
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put(FIELD_STATUS, this.getStatus().name());
        if (this.errorInfo != null) {
            data.put(FIELD_PRINTER_IDS, this.errorInfo.getPrinterIds().stream().map(String::valueOf).collect(Collectors.toCollection(Vector::new)));
            data.put(FIELD_PRINTER_STATUS, String.valueOf((Object)this.errorInfo.getPrinterStatus()));
        }
        return data;
    }

    public ReleaseStatusCode getStatus() {
        return this._status;
    }

    @Nullable
    public ReleaseStatusErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setStatus(ReleaseStatusCode status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot have null status");
        }
        this._status = status;
    }

    public void setErrorInfo(@Nullable ReleaseStatusErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        tsb.append(FIELD_STATUS, (Object)this.getStatus());
        return tsb.toString();
    }

    public static class ReleaseStatusErrorInfo {
        private final ReleasePrinterStatus printerStatus;
        private final Set<Long> printerIds;

        public ReleaseStatusErrorInfo(Set<Long> printerIds, ReleasePrinterStatus printerStatus) {
            this.printerStatus = printerStatus;
            this.printerIds = printerIds;
        }

        public ReleasePrinterStatus getPrinterStatus() {
            return this.printerStatus;
        }

        public Set<Long> getPrinterIds() {
            return this.printerIds;
        }
    }
}

