/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public class RandomTime {
    public static Duration durationBetween(Duration fromDuration, Duration toDuration) {
        return Duration.ofMillis(RandomTime.random().nextLong(fromDuration.toMillis(), toDuration.toMillis()));
    }

    public static Duration durationWithJitter(Duration duration, double jitterFactor) {
        Preconditions.checkArgument((jitterFactor >= 0.0 ? 1 : 0) != 0, (Object)"jitterFactor must be >= 0.0");
        Preconditions.checkArgument((jitterFactor <= 1.0 ? 1 : 0) != 0, (Object)"jitterFactor must be <= 1.0");
        double randomFactor = 1.0 + (1.0 - RandomTime.random().nextDouble() * 2.0) * jitterFactor;
        return Duration.ofMillis((long)((double)duration.toMillis() * randomFactor));
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    private RandomTime() {
    }
}

