/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ReplaceInvalidUnicodeReader
extends FilterReader {
    private final char _replacement;

    public ReplaceInvalidUnicodeReader(Reader in, char replacement) {
        super(in);
        this._replacement = replacement;
    }

    @Override
    public int read() throws IOException {
        int codePoint;
        int ch = super.read();
        if (ch >= 0 && !Character.isDefined(codePoint = ch)) {
            return this._replacement;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int readChars = super.read(cbuf, off, len);
        for (int i = off; i < off + readChars; ++i) {
            int codePoint = Character.codePointAt(cbuf, i);
            if (Character.isDefined(codePoint)) continue;
            cbuf[i] = this._replacement;
        }
        return readChars;
    }
}

