/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class FlashYesNo
extends JPanel
implements FlashContent {
    private final JButton _yesButton;
    private final JButton _noButton;
    private final boolean _defaultYesSelected;
    private volatile FlashContent.FlashContentEventHandler _eventHandler;

    public FlashYesNo(@Nullable String title, String description, Color foreground, Color background, SubmitListener submitListener, boolean defaultYesSelected) {
        description = StringUtils.trimToEmpty((String)description).replace("\n", "<br />");
        this._defaultYesSelected = defaultYesSelected;
        int pad = 10;
        this.setOpaque(true);
        this.setBackground(background);
        this.setForeground(foreground);
        this.setBorder(BorderFactory.createLineBorder(foreground, 2));
        this.setLayout(new BorderLayout(10, 10));
        if (title != null) {
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.setBackground(background);
            titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, foreground), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setForeground(foreground);
            titlePanel.add((Component)titleLabel, "West");
            this.add((Component)titlePanel, "North");
        }
        JLabel descriptionLabel = new JLabel("<html><center>" + description + "</center></html>");
        descriptionLabel.setForeground(foreground);
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        this.add((Component)descriptionLabel, "Center");
        this._yesButton = new JButton(Messages.getString(this.getClass(), "FlashYesNo.yes", new String[0]));
        SwingUtils.setOpaqueIfRequired(this._yesButton);
        this._yesButton.addActionListener(e -> {
            submitListener.submitPerformed(true);
            this._eventHandler.hide();
        });
        this._noButton = new JButton(Messages.getString(this.getClass(), "FlashYesNo.no", new String[0]));
        SwingUtils.setOpaqueIfRequired(this._noButton);
        this._noButton.addActionListener(e -> {
            submitListener.submitPerformed(false);
            this._eventHandler.hide();
        });
        JPanel buttonBar = new JPanel();
        buttonBar.setOpaque(false);
        buttonBar.add((Component)this._yesButton, "Before");
        buttonBar.add((Component)this._noButton, "After");
        this.add((Component)buttonBar, "South");
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEventHandler(FlashContent.FlashContentEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    @Override
    public void showing() {
        if (this._defaultYesSelected) {
            this._yesButton.requestFocus();
        } else {
            this._noButton.requestFocus();
        }
    }

    public static interface SubmitListener {
        public void submitPerformed(boolean var1);
    }
}

