/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientAccountFile;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientAccountCache {
    private static final Logger logger = LoggerFactory.getLogger(ClientAccountCache.class);
    private static ClientAccountCache _instance;
    private volatile ServerConnection _connection;
    private volatile UserClientConfig _config;
    private volatile List<ClientAccount> _accounts;
    private volatile long _cacheLastModifiedTime;
    private volatile CacheSource _source;
    private volatile String _serverAssociatedUser;
    private final boolean _dontCacheAccountsFromServer;
    private static final long FILE_TIME_PRECISION = 3000L;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("account-list-background-loader-" + System.currentTimeMillis()).setUncaughtExceptionHandler((t, e) -> logger.error("Account list loading failed", e)).build(), new ThreadPoolExecutor.DiscardPolicy());

    private ClientAccountCache(ServerConnection conn, UserClientConfig config) {
        this._connection = conn;
        this._config = config;
        this._dontCacheAccountsFromServer = config.isDisableAccountCache();
        this.preloadAccountFileIfRequired();
    }

    private void preloadAccountFileIfRequired() {
        try {
            this.getAccountFile(this._config).ifPresent(this::scheduleAccountFileReloading);
        }
        catch (RuntimeException e) {
            logger.error("Failed to setup preloading of client account file", (Throwable)e);
        }
    }

    private void scheduleAccountFileReloading(File file) {
        if (this._config.isClientAccountsFileDisablePreload()) {
            logger.debug("Account file reloading is disabled");
        } else {
            long period = 60L;
            logger.debug("Schedule account file reloading every " + period + " seconds");
            this.executorService.scheduleWithFixedDelay(() -> {
                try {
                    logger.debug("Check client account file: " + file.getAbsolutePath() + " for reloading...");
                    this.loadAccountClientFileCallable(file.getAbsolutePath(), file.lastModified()).call();
                }
                catch (Exception e) {
                    logger.error("failed to load client account file: " + file, (Throwable)e);
                }
            }, 0L, period, TimeUnit.SECONDS);
        }
    }

    public synchronized List<ClientAccount> getUserAccounts(ClientPrintJob job, String username, Component parentDialog) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.debug("Load account list for user: " + username + " for job: " + job);
        this.loadAccountsFromSiteAccountFileIfRequired(parentDialog);
        if (this._source != CacheSource.File) {
            this.loadAccountsFromServerIfRequired(job, username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Took: " + stopwatch + ", available accounts: " + (this._accounts.size() > 50 ? Integer.valueOf(this._accounts.size()) : this._accounts));
        }
        return this._accounts;
    }

    private Optional<File> getAccountFile(UserClientConfig config) {
        if (StringUtils.isBlank((String)config.getClientAccountsFile())) {
            return Optional.empty();
        }
        File accountsFile = new File(config.getClientAccountsFile());
        String clientAccountsFileName = accountsFile.getAbsolutePath();
        boolean accountFileExists = accountsFile.exists();
        if (!accountFileExists) {
            logger.debug("Accounts file does not exist: " + clientAccountsFileName);
            if (this._source == CacheSource.File) {
                this.invalidateCache();
            }
            throw new IllegalStateException("Account file does not exist. File: " + clientAccountsFileName);
        }
        long fileLastModified = accountsFile.lastModified();
        if (fileLastModified == 0L) {
            logger.debug("Cannot determine account last modified time: " + clientAccountsFileName);
            if (this._source == CacheSource.File) {
                this.invalidateCache();
            }
            throw new IllegalStateException("Cannot determine whether the file has been recently modified.");
        }
        return Optional.of(accountsFile);
    }

    private void loadAccountsFromSiteAccountFileIfRequired(Component parentDialog) {
        try {
            Optional<File> accountsFile = this.getAccountFile(this._config);
            if (!accountsFile.isPresent()) {
                return;
            }
            String clientAccountsFileName = accountsFile.get().getAbsolutePath();
            long fileLastModified = accountsFile.get().lastModified();
            this.loadClientAccountFile(clientAccountsFileName, fileLastModified);
        }
        catch (IOException | RuntimeException e) {
            this.displayLoadFileError(e.getMessage(), parentDialog);
        }
    }

    private static long normalizeFileTimestamp(long fileLastModified) {
        return fileLastModified + 3000L;
    }

    private Callable<Void> loadAccountClientFileCallable(String clientAccountsFileName, long fileLastModified) {
        return () -> {
            this.loadClientAccountFile(clientAccountsFileName, fileLastModified);
            return null;
        };
    }

    private synchronized void loadClientAccountFile(String clientAccountsFileName, long fileLastModified) throws IOException {
        logger.debug("loadAccountClientFile: " + clientAccountsFileName);
        boolean loadDisabledSharedAccounts = this._config.isLoadDisabledAccounts();
        fileLastModified = ClientAccountCache.normalizeFileTimestamp(fileLastModified);
        if (this._accounts == null || fileLastModified > this._cacheLastModifiedTime) {
            logger.debug("Accounts need to be reloaded from file: " + clientAccountsFileName);
            List accounts = ClientAccountFile.readClientAccountFile((String)clientAccountsFileName, (int)3, (boolean)loadDisabledSharedAccounts);
            this.storeCachedAccounts(null, accounts, fileLastModified, CacheSource.File);
        }
    }

    private void displayLoadFileError(String detailedError, Component parentComponent) {
        String title = Messages.getString(ClientAccountCache.class, "SelectAccount.error", new String[0]);
        Object msg = StringUtils.isBlank((String)detailedError) ? Messages.getString(ClientAccountCache.class, "cannot-load-accounts-file", new String[0]) : Messages.getString(ClientAccountCache.class, "cannot-load-accounts-file", new String[0]) + "\n\n" + detailedError;
        SwingUtilities.invokeLater(() -> ClientAccountCache.lambda$displayLoadFileError$3(parentComponent, title, (String)msg));
    }

    private void invalidateCache() {
        this.storeCachedAccounts(null, null, 0L, null);
    }

    private void loadAccountsFromServerIfRequired(ClientPrintJob job, String username) {
        logger.debug("Load accounts from server (if required). User: " + username + ", Cached user: " + this._serverAssociatedUser + ", cached mod time: " + new Date(this._cacheLastModifiedTime) + ", cached source: " + this._source);
        username = StringUtils.trimToEmpty((String)username);
        if (this._dontCacheAccountsFromServer) {
            this.loadAccountsFromServer(job, username, 0L);
        } else {
            long accountsLastModified = Long.parseLong(this._connection.getUserAccountsLastModifiedTime(job));
            if (this._accounts == null || accountsLastModified > this._cacheLastModifiedTime || this._source == CacheSource.Server && !StringUtils.equals((String)this._serverAssociatedUser, (String)username)) {
                logger.debug("Accounts need to be reloaded from server");
                this.loadAccountsFromServer(job, username, accountsLastModified);
            } else {
                logger.debug("Using accounts cached at: " + new Date(this._cacheLastModifiedTime) + ", for user: " + this._serverAssociatedUser);
            }
        }
    }

    synchronized void storeCachedAccounts(@Nullable String username, @Nullable List<ClientAccount> accounts, long accountsLastModified, @Nullable CacheSource cacheSource) {
        this._accounts = accounts;
        this._cacheLastModifiedTime = accountsLastModified;
        this._serverAssociatedUser = username;
        this._source = cacheSource;
    }

    private void loadAccountsFromServer(ClientPrintJob job, String username, long accountsLastModified) {
        boolean loadDisabledSharedAccounts = this._config.isLoadDisabledAccounts();
        if (StringUtils.isBlank((String)username)) {
            this.storeCachedAccounts(username, this._connection.getAllSharedAccounts(loadDisabledSharedAccounts), accountsLastModified, CacheSource.Server);
        } else {
            this.storeCachedAccounts(username, this._connection.getUserAccounts(job, username, loadDisabledSharedAccounts), accountsLastModified, CacheSource.Server);
        }
    }

    public static synchronized ClientAccountCache initialise(ServerConnection conn, UserClientConfig config) {
        if (_instance == null) {
            _instance = new ClientAccountCache(conn, config);
        } else {
            ClientAccountCache._instance._connection = conn;
        }
        return _instance;
    }

    public static synchronized ClientAccountCache getInstance() {
        Preconditions.checkState((_instance != null ? 1 : 0) != 0, (Object)"Client account cache is not initialized.");
        return _instance;
    }

    public synchronized void clear() {
        logger.debug("Clear account cache");
        this.invalidateCache();
    }

    private static /* synthetic */ void lambda$displayLoadFileError$3(Component parentComponent, String title, String msg) {
        DialogUtils.showInformationMessageDialog((Component)parentComponent, (String)title, (String)msg);
    }

    private static enum CacheSource {
        Server,
        File;

    }
}

