/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.RecentListTableModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.EnterFilteringInputMap;
import com.google.common.base.Stopwatch;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentList
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(RecentList.class);
    private static final int COL_IDX_ACCOUNT = 0;
    private static final int COL_IDX_CODE = 1;
    private static final int PREF_WIDTH = 100;
    private JTable _table;
    private RecentListTableModel _tableModel;
    private final boolean _showCode;

    public RecentList(boolean showCode) {
        this._showCode = showCode;
        this.layoutComponents();
    }

    public void loadData(List<ClientAccount> accounts, List<Long> recentAccounts) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this._tableModel.loadData(accounts, recentAccounts);
        this._table.changeSelection(0, 0, false, false);
        logger.debug("Loading {} accounts in RecentList took {} ms", (Object)accounts.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void dispose() {
        this._tableModel.dispose();
    }

    private void layoutComponents() {
        this._tableModel = new RecentListTableModel();
        this._table = new JTable(this._tableModel);
        EnterFilteringInputMap.applyToComponent((JComponent)this._table);
        if (!this._showCode) {
            TableColumnModel colModel = this._table.getColumnModel();
            colModel.removeColumn(colModel.getColumn(1));
        }
        this._table.setPreferredScrollableViewportSize(new Dimension(100, 50));
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        this._table.setSelectionMode(0);
        DefaultTableCellRenderer accountRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                if (value instanceof ClientAccount) {
                    ClientAccount ca = (ClientAccount)value;
                    this.setEnabled(!ca.isDisabled());
                }
            }
        };
        TableColumn accountCol = this._table.getColumn(Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]));
        accountCol.setCellRenderer(accountRenderer);
        JScrollPane scrollPane = new JScrollPane(this._table);
        scrollPane.getViewport().setBackground(this._table.getBackground());
        scrollPane.setOpaque(false);
        FormLayout layout = new FormLayout("pref:grow", "pref:grow");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.add((Component)scrollPane, cc.xy(1, 1, CellConstraints.FILL, CellConstraints.FILL));
    }

    public ClientAccount getSelectedAccount() {
        Object value;
        ClientAccount selectedAccount = null;
        RecentListTableModel model = (RecentListTableModel)this._table.getModel();
        int row = this._table.getSelectedRow();
        if (row >= 0 && (value = model.getValueAt(row, 0)) instanceof ClientAccount) {
            selectedAccount = (ClientAccount)model.getValueAt(row, 0);
        }
        return selectedAccount;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().addListSelectionListener(listener);
    }
}

