/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.PropertiesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFile.class);

    public static Properties load(String configFilePath) throws IOException {
        File f = new File(configFilePath);
        logger.debug("Loading config file: {}", (Object)f.getPath());
        if (!f.exists() && !f.isFile()) {
            throw new FileNotFoundException("PaperCut config file '" + configFilePath + "' does not exist.");
        }
        if (!f.canRead()) {
            throw new FileNotFoundException("No permissions to read the config file '" + configFilePath + "'. Check the file permissions.");
        }
        return ConfigFile.load(f);
    }

    private static Properties load(File file) throws IOException {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            PropertiesUtils.loadProperties(fis, props);
        }
        return props;
    }
}

