/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxList
extends JList<Object> {
    private final Set<Integer> _selectionCache = new HashSet<Integer>();
    private final ListCellRenderer<Object> _origCellRenderer = this.getCellRenderer();
    private final ListSelectionListener _selectionListener;

    public void setEmptyMessage(String msg) {
        this.setCellRenderer(this._origCellRenderer);
        this.setListData(new String[]{" " + msg});
        this.setEnabled(false);
    }

    public CheckBoxList() {
        this.setCellRenderer(new CellRenderer());
        this._selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int size = CheckBoxList.this.getModel().getSize();
                CheckBoxList.this.removeListSelectionListener(CheckBoxList.this._selectionListener);
                HashSet<Integer> newSelections = new HashSet<Integer>();
                for (int i = 0; i < size; ++i) {
                    if (!CheckBoxList.this.getSelectionModel().isSelectedIndex(i)) continue;
                    newSelections.add(i);
                }
                for (Integer index : CheckBoxList.this._selectionCache) {
                    CheckBoxList.this.getSelectionModel().addSelectionInterval(index, index);
                }
                for (Integer index : newSelections) {
                    if (CheckBoxList.this._selectionCache.contains(index)) {
                        CheckBoxList.this.getSelectionModel().removeSelectionInterval(index, index);
                        continue;
                    }
                    CheckBoxList.this.getSelectionModel().addSelectionInterval(index, index);
                }
                CheckBoxList.this._selectionCache.clear();
                for (int i = 0; i < size; ++i) {
                    if (!CheckBoxList.this.getSelectionModel().isSelectedIndex(i)) continue;
                    CheckBoxList.this._selectionCache.add(i);
                }
                CheckBoxList.this.addListSelectionListener(CheckBoxList.this._selectionListener);
            }
        };
        this.addListSelectionListener(this._selectionListener);
    }

    protected class CellRenderer<E>
    extends JComponent
    implements ListCellRenderer<E> {
        private final JCheckBox _checkBox = new JCheckBox();
        private final DefaultListCellRenderer _defaultComp;
        private final Color _listForeground;
        private final Color _listBackground;

        public CellRenderer() {
            this.setLayout(new BorderLayout());
            this._defaultComp = new DefaultListCellRenderer();
            this.add((Component)this._checkBox, "West");
            this.add((Component)this._defaultComp, "Center");
            UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
            this._listForeground = uid.getColor("List.foreground");
            this._listBackground = uid.getColor("List.background");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component[] comps;
            this._defaultComp.getListCellRendererComponent((JList<?>)list, value, index, true, false);
            this._checkBox.setSelected(CheckBoxList.this._selectionCache.contains(index));
            for (Component comp : comps = this.getComponents()) {
                comp.setForeground(this._listForeground);
                comp.setBackground(this._listBackground);
            }
            return this;
        }
    }
}

