/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class RecentListTableModel
extends AbstractTableModel {
    private List<Long> _recentAccountIds;
    private List<ClientAccount> _recentAccountList;

    public RecentListTableModel() {
        ClientAccount ca = new ClientAccount(1L);
        ca.setDisabled(true);
        ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
        this._recentAccountList = new ArrayList<ClientAccount>(1);
        this._recentAccountList.add(ca);
    }

    public void loadData(List<ClientAccount> accounts, List<Long> recentAccountIds) {
        this._recentAccountIds = recentAccountIds;
        this.buildList(accounts);
        this.fireTableDataChanged();
    }

    private void buildList(List<ClientAccount> accounts) {
        this._recentAccountList = new ArrayList<ClientAccount>(this._recentAccountIds.size());
        for (ClientAccount a : accounts) {
            if (!this._recentAccountIds.contains(a.getAccountId()) || a.isDisabled()) continue;
            this._recentAccountList.add(a);
        }
    }

    public void dispose() {
        this._recentAccountList.clear();
        this._recentAccountIds.clear();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
        }
        if (column == 1) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
        }
        throw new IllegalArgumentException("Unexpected column index");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._recentAccountList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (rowIndex >= this._recentAccountList.size()) {
                return "";
            }
            ClientAccount a = this._recentAccountList.get(rowIndex);
            if (a != null) {
                return a;
            }
            return "--error--";
        }
        if (columnIndex == 1) {
            ClientAccount a = this._recentAccountList.get(rowIndex);
            if (a != null) {
                return a.getFullPin();
            }
            return "";
        }
        throw new IllegalArgumentException("unexpected column index");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }
}

